/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j2d.color.rgbImageFilters;




/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 27, 2005
 * <p/>
 * Time: 8:10:56 AM
 */
public class ColorSafeFilter extends RgbFilterProcessor {
    private static final int lut[] = getLut();
    public ColorSafeFilter() {
        // When this is set to true, the filter will work with images
        // whose pixels are indices into a color table (IndexColorModel).
        // In such a case, the color values in the color table are filtered.
        canFilterIndexColorModel = true;
    }

    public int filterRGB(int x, int y, int rgb) {
        return (0xff000000|
                lut[((rgb & 0x00ff0000)>>16)] << 16 |
                lut[((rgb & 0x0000ff00) >> 8)] << 8 |
                lut[(rgb & 0x000000ff)]);
    }
    private static int[] getLut(){
        int lut[]= new int[256];
        for (int i=0; i < lut.length;i++)
            lut[i] = f(i);
        return lut;
    }

    public static int map(int a) {

        final int mask =  a % 51;
        int base = (a - mask) / 51;
        //if (base != 0)
        if (base == 5)
            if (mask > 1)
                base++;
        if (base == 4)
            if (mask > 11)
                base++;
        if (base == 3)
            if (mask > 20)
                base++;
        if (base == 2)
            if (mask > 30)
                base++;
        if (base == 1)
            if (mask > 39)
                base++;
        if (base == 0)
            if (mask > 49)
                base++;
        return (short) ((short) base * 51);
    }
    public static int f(int x){
        if (x < 50) return 0;
        if (x < 91) return 51;
        if (x < 133) return 102;
        if (x < 174) return 153;
        if (x < 217) return 204;
        return 255;
    }
    public static int g(int x) {
        // divide the interval into 6 equal parts
        // of 42.5 each.
        if (x < 42.5) return 0;
        if (x < 85) return 51;
        if (x < 127.5) return 102;
        if (x < 170) return 153;
        if (x < 212.5) return 204;
        return 255;
    }
    public static void main(String[] args) {
        int lut[] = getLut();
        for (int i=0; i <lut.length;i++)
            System.out.println(i+","+lut[i]+","+f(i)+","+g(i));
    }
}
