/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Mar 3, 2003
 * Time: 5:45:44 PM
 */
package j2d.color.lut;

import gui.In;
import j2d.ImagePanel;
import j2d.ImageUtils;
import j2d.ShortImageBean;
import j2d.color.IndexImageBean;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;



public class IndexImageFrame extends JFrame {
    private IndexImageBean iib =
            getSpectrogramIndexBean();

    private ImagePanel ip = new ImagePanel(iib.getImage());

    public static IndexImageBean getIndexImageBean() {
        try {
            return new IndexImageBean(new ShortImageBean(//ImageUtils.getImage()));
                    ImageUtils.captureWholeScreen()));
        } catch (AWTException e) {
            return null;

        }
    }

    public static IndexImageBean getSpectrogramIndexBean() {
        return new IndexImageBean(getSpectrogramImageBean());
    }

    public static ShortImageBean getSpectrogramImageBean() {
        ShortImageBean sib = new ShortImageBean(600, 600);
        short b[][] = sib.getB();
        for (int i = 0; i < b.length; i++) {
            for (int j = 0; j < b[0].length; j++) {
                b[i][j] = (short) 0;
            }
        }
        return sib;
    }


    public void incrementImage() {
        iib.add((byte) 1);
        //ip.setImage(iib.getImage());
        ip.setImage(iib.getImage());
    }

    public MouseMotionListener getMouseMotionListener() {
        return new MouseMotionListener() {
            public void mouseDragged(MouseEvent e) {
                Point pt = e.getPoint();
                Panel p = new Panel();
                p.setSize(iib.getSize());
                iib.drawSquare(pt.x, pt.y,50);
            }

            public void mouseMoved(MouseEvent e) {
            }
        };
    }

    public static void main(String[] args) {
        new IndexImageFrame();
        //todo create a graph of the spectrogram
        //graphics.grapher.Main.main(args);
    }

    public static short getRandom() {
        return (short) (Math.random() * 255);
    }

    public Image getIndexImage() {
        IndexImageBean iib = new IndexImageBean(new ShortImageBean(getImage()));
        return iib.getImage();
    }

    public Image getImage() {
        ShortImageBean sib = new ShortImageBean(400, 400);
        short r[][] = sib.getR();
        short g[][] = sib.getG();
        short b[][] = sib.getB();
        for (int x = 0; x < r.length; x++)
            for (int y = 0; y < r[0].length; y++) {
                int xc = x - 200;
                int yc = y - 200;
                if ((xc * xc + yc * yc) < 10000) {
                    r[x][y] = getRandom();
                    g[x][y] = getRandom();
                    b[x][y] = getRandom();
                }
            }
        return sib.getImage();
    }

    public IndexImageFrame() {
        Container c = super.getContentPane();
        gui.layouts.PreferredSizeGridLayout
                lo = new gui.layouts.PreferredSizeGridLayout(0, 1);
        lo.setBoundableInterface(new
                gui.layouts.AspectBoundable());

        c.setLayout(lo);


        c.add(ip);
        setSize(iib.getSize());
        setDefaultCloseOperation(HIDE_ON_CLOSE);
        setVisible(true);
        ip.addMouseMotionListener(getMouseMotionListener());
        for (; true;) {
            incrementImage();
            try {
                Thread.sleep(10);
            } catch (InterruptedException e) {
                In.message(e);

            }
        }

    }
}
