package j2d.color.histogram24Slow;

import java.awt.*;
import java.util.HashMap;
import java.util.Iterator;

/**
 * Created by IntelliJ IDEA.
 * User: Dave Pavlik
 * Date: Apr 20, 2005
 * Time: 1:34:34 PM
 */
public class ColorMapGenerator extends j2d.ImageProcessor {
    private int[] pixel;   // All the rgb pixels in the image
    private HashMap colorMap =
            new HashMap(); // HashMap(Color color, int totalPixels)

    public ColorMapGenerator(Image image) {
        setBaseImage(image);
    }

    public HashMap getColorMap() {
        return colorMap;
    }

    public void processImage() {
        pixel = this.getPixels();

        // 3 HashMaps are used to tally the total pixels
        // for each combination of red, green, blue as it
        // occurs. The HashMap key = the color level (0 to 255).
        // The red HashMap value = the green HashMap.
        // The green HashMap value = the blue HashMap.
        // The blue HashMap value = the total pixels of that color.
        String redLevel = null;
        String greenLevel = null;
        String blueLevel = null;

        HashMap redMap = new HashMap();
        HashMap greenMap = new HashMap();
        HashMap blueMap = new HashMap();

        int pixelCount;
        int red, green, blue;

        // Check each pixel in the image
        for (int i = 0; i < pixel.length; i++) {
            redLevel = Integer.toString((pixel[i] & 0x00FF0000) >> 16);
            greenLevel = Integer.toString((pixel[i] & 0x0000FF00) >> 8);
            blueLevel = Integer.toString((pixel[i] & 0x000000FF));

            // Check if level already exists for each color. If
            // combination exists the pixelCount is incremented.
            // If a level for a color doesn't exist yet it is added
            // along with a new HashMap and level for the color(s)
            // that follow it (ie; red > green > blue).
            if (redMap.containsKey(redLevel)) {
                greenMap = (HashMap) redMap.get(redLevel);
                if (greenMap.containsKey(greenLevel)) {
                    blueMap = (HashMap) greenMap.get(greenLevel);
                    if (blueMap.containsKey(blueLevel)) {
                        pixelCount = Integer.parseInt((String) blueMap.get(blueLevel));
                        pixelCount++;
                        blueMap.remove(blueLevel);
                        blueMap.put(blueLevel, Integer.toString(pixelCount));
                    } else {
                        pixelCount = 1;
                        blueMap.put(blueLevel, Integer.toString(pixelCount));
                    }
                } else {
                    blueMap = new HashMap();
                    pixelCount = 1;
                    greenMap.put(greenLevel, blueMap);
                    blueMap.put(blueLevel, Integer.toString(pixelCount));
                }
            } else {
                greenMap = new HashMap();
                blueMap = new HashMap();
                pixelCount = 1;
                redMap.put(redLevel, greenMap);
                greenMap.put(greenLevel, blueMap);
                blueMap.put(blueLevel, Integer.toString(pixelCount));
            }
        }

        Iterator redIndex = redMap.keySet().iterator();

        do {
            Object redKey = redIndex.next();           // Returns red value as Object
            greenMap = (HashMap) (redMap.get(redKey));
            Iterator greenIndex = greenMap.keySet().iterator();
            do {
                Object greenKey = greenIndex.next();   // Returns green value as Object
                blueMap = (HashMap) (greenMap.get(greenKey));
                Iterator blueIndex = blueMap.keySet().iterator();
                do {
                    Object blueKey = blueIndex.next(); // Returns blue value as Object
                    pixelCount = Integer.parseInt(blueMap.get(blueKey).toString());
                    red = Integer.parseInt(redKey.toString());
                    green = Integer.parseInt(greenKey.toString());
                    blue = Integer.parseInt(blueKey.toString());
                    pixelCount = Integer.parseInt(blueMap.get(blueKey).toString());
                    colorMap.put(new Color(red, green, blue), Integer.toString(pixelCount));
                } while (blueIndex.hasNext());
            } while (greenIndex.hasNext());
        } while (redIndex.hasNext());

    }
}



















