package j2d.color.histogram24Slow;

import j2d.ImageUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.awt.*;

public class ColorMap {
    private static double pmf[][];
    private static ColorMapGenerator cmg;
    private static HashMap colorMap;
    static int pmf_part = 1;
    static int color_part = 0;
    static int pair_size = 2;

    public static void createColorMap(){
        Image image = ImageUtils.getImage();
        cmg = new ColorMapGenerator(image);
        cmg.processImage();
        colorMap = cmg.getColorMap();
    }

    public static void main(String[] args) {
        createColorMap();
        calcPmf();
        quicksort(pmf, 0, pmf.length-1);

        System.out.println("Most Probable:");
        for(int i=0; i<10; i++){
            System.out.println(pmf[i][color_part] + " " + pmf[i][pmf_part]);
        }
        System.out.println("Least Probable:");
        for(int j=pmf.length-1; j>pmf.length-11; j--){
            System.out.println(pmf[j][color_part] + " " + pmf[j][pmf_part]);
        }
    }

    public static void calcPmf(){
        Iterator colorMapIndex = colorMap.keySet().iterator();

        pmf = new double[colorMap.size()][pair_size];
        int colorCount = 0;
        int totalPixels = cmg.getBaseImageHeight() * cmg.getBaseImageWidth();
        double totalPmf = 0;

        do {
            Object colorKey = colorMapIndex.next();    // Returns color as Object
            Color color = (Color) colorKey;
            float pixelCount = Integer.parseInt(       // pixels per this one color
                    colorMap.get(colorKey).toString());

            pmf[colorCount][pmf_part] = pixelCount / totalPixels;
            pmf[colorCount][color_part] = colorCount;
            System.out.println( colorCount + ". " + color.toString() + " count is " +
                    pixelCount + "(PMF is " + pmf[colorCount][pmf_part] + ")");

            colorCount++;

        } while (colorMapIndex.hasNext());
    }

    public static void quicksort(double[][] a, int left, int right) {
        if (right <= left) return;
        int i = partition(a, left, right);
        quicksort(a, left, i-1);
        quicksort(a, i+1, right);
    }

    private static int partition(double[][] a, int left, int right) {
        int i = left - 1;
        int j = right;
        while(true) {
            while (more(a[++i][pmf_part], a[right][pmf_part]))       // find item on left to swap
                ;                                // a[right] acts as sentinel
            while (more(a[right][pmf_part], a[--j][pmf_part]))       // find item on right to swap
                if (j == left) break;            // don't go out-of-bounds
            if (i >= j) break;                   // check if pointers cross
            exch(a, i, j);                       // swap two elements into place
        }
        exch(a, i, right);                       // swap with partition element
        return i;
    }

    // is x < y ?
    private static boolean more(double x, double y) {
        return (x > y);
    }

    // exchange a[i] and a[j]
    private static void exch(double[][] a, int i, int j) {
        double[] swap = a[i];
        a[i] = a[j];
        a[j] = swap;
    }
}
