package j2d.color.histogram24;

import j2d.ShortImageBean;

/**
 * Created by Robert Distinti.
 * User: default
 * Date: Oct 2, 2005
 * Time: 10:29:17 AM
 */
public class MyRgbColorStats {

    private ShortImageBean sib;
    // kep reference to it in case we have to do other processing later
    private ColorLink Base=new ColorLink();
    // This first is niether red nor green nor blue -- just the seed
    private ColorLink pFirstLowest=null;
    private ColorLink pFirstSort=null;
    private int uniqueColors;
    private int totalPixels;

    private class ColorLink{
        public ColorLink pNext=null;
        public ColorLink pDown=null;
        public ColorLink pUp=null;
        public ColorLink pNextLowest=null;
        public ColorLink pNextSort=null;
        public short myColor;
        public int count;
        public ColorLink(short col, boolean isLowest, ColorLink pHigher){
            myColor=col;
            count=1;
            pUp=pHigher;
            if(isLowest){
                uniqueColors++;
                if(pFirstLowest!=null){
                    pNextLowest=pFirstLowest;
                }
                pFirstLowest=this;
            }
        }
        public ColorLink(){
            myColor=-1;
            count=0;
        }
    }

    private final void addSortColor(ColorLink pAdd){
        if (pFirstSort==null){
            pFirstSort=pAdd;
            pAdd.pNextSort=null;
            return;
        }
        ColorLink pS=pFirstSort;
        ColorLink pL=null;
        while(pS!=null){
            if(pS.count<=pAdd.count){
                //insert here
                if(pL==null){
                    pAdd.pNextSort=pS;
                    pFirstSort=pAdd;
                }else{
                    pAdd.pNextSort=pS;
                    pL.pNextSort=pAdd;
                }
                return;
            }
            pL=pS;
            pS=pS.pNextSort;
        }
        // if we got here it means we got to end (pL=end)
        pL.pNextSort=pAdd;
        pAdd.pNextSort=null;
    }


    private void SortColors(){
        ColorLink pN=pFirstLowest;
        int checkCnt=0;
        System.out.println("\r\n Sorting by count");
        while(pN!=null){
            addSortColor(pN);
            pN=pN.pNextLowest;
            checkCnt++;
            if (checkCnt%1000==0)System.out.println(checkCnt);

        }
        System.out.println(" Sorting of "+checkCnt+" colors complete");
    }

    private void reset(){
        uniqueColors=0;
        totalPixels=0;
        Base=new ColorLink();
    }

    /**
     * this function asserts that the higher color was already found
     *  for the case of red, use the
     * @param c
     * @param isLowest
     * @param higher
     * @return
     */
    private final ColorLink addSubColor(short c,boolean isLowest, ColorLink higher ){
        if (higher.pDown!=null){
            ColorLink pN=higher.pDown;
            ColorLink pL=null;
            while(pN!=null){
                if(pN.myColor==c){
                    pN.count++;
                    return pN;
                }
                pL=pN;
                pN=pN.pNext;
            }
            if(pL!=null){
                pL.pNext=new ColorLink(c,isLowest,higher);
                return pL.pNext;
            }
            return null;
        }else{
            higher.pDown=new ColorLink(c,isLowest, higher);
            return higher.pDown;
        }
    }

    private final void addColor(short r, short g, short b){
        final ColorLink higher = addSubColor(r,false, Base);
        final ColorLink higher2 = addSubColor(g,false, higher);
        addSubColor(b,true, higher2);
    }

    private String getColorInfoString(ColorLink pL){
        int r,g,b;
        int cnt;
        b=pL.myColor;
        cnt=pL.count;
        pL=pL.pUp;
        g=pL.myColor;
        pL=pL.pUp;
        r=pL.myColor;
        return "Color r["+r+"]g["+g+"]b["+b+"] count="+cnt+" ";
    }

    public String getFirst(int n){
        String rtn;
        ColorLink pS=pFirstSort;
        rtn="The first "+n+" PMF entries are: \r\n";
        for(int i=0; i<n&&pS!=null ; i++){
            double PMF=(double)pS.count/(double)totalPixels;
            rtn=rtn+getColorInfoString(pS)+"PMF="+PMF+"\r\n";
            pS=pS.pNextSort;
        }
        return rtn;
    };


    public String getLast(int n){
        String rtn;
        ColorLink pS=pFirstSort;
        int i;
        int bleed;
        bleed=uniqueColors-n;
        if(bleed>0){
            for (i=0; i<bleed; i++){
                pS=pS.pNextSort;
            }
        }
        rtn="The last "+n+" PMF entries are: \r\n";
        for(i=0; i<n&&pS!=null ; i++){
            double PMF=(double)pS.count/(double)totalPixels;
            rtn=rtn+getColorInfoString(pS)+"PMF="+PMF+"\r\n";
            pS=pS.pNextSort;
        }
        return rtn;
    }


    private final void addColor(int c){
        short b=(short)(c&0xFF);
        short g=(short)((c>>8)&0xff);
        short r=(short)((c>>16)&0xFF);
        addColor(r,g,b);
    }

    private void addColors(){
        int[] pels=sib.getPels();
        reset();
        totalPixels=pels.length;
        for(int i=0; i<pels.length; i++){
            addColor(pels[i]);
        }
    }


    public MyRgbColorStats(ShortImageBean sib){
        this.sib=sib;
        addColors();
        SortColors();
    }

    public int getUniqueColorCount(){
        return uniqueColors;
    }


}
