/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package j2d.color;

import j2d.ShortImageBean;

import java.awt.*;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jul 20, 2005
 * <p/>
 * Time: 2:56:21 PM
 */

/**
 * Use the IndexImageBean in order to create an 8 bit color image with 256
 * colors. You can set the look up table (LUT) anyway that you like.
 */
public class IndexImageBean {
    private Dimension size;
    private byte pixels[];
    private IndexColorModel indexColorModel = IndexImageBean.getSpectrum();
    //private IndexColorModel indexColorModel = IndexImageBean.getIce();
    /**
     * Make an instance of an IndexImageBean from a ShortImageBean. Just
     * use the blue pels.
     */
    public IndexImageBean(ShortImageBean sib) {
        size = new Dimension(sib.getWidth(), sib.getHeight());
        pixels = sib.getPelsFromBlue();
    }

    /**
     * Add k to each pel.
     */
    public void add(int k) {
        for (int i = 0; i < pixels.length; i++)
            pixels[i] = (byte) (pixels[i] + k);
    }

    /**
     * An IndexColorModel serves as a LUT (Look-up table) Values in the
     * IndexImage Are mapped to colors in RGB space.
     */
    public static IndexColorModel getIce() {

        int[] r = {
            0, 0, 0, 0, 0, 0, 19, 29, 50, 48, 79, 112, 134, 158, 186, 201, 217, 229,
            242, 250, 250, 250, 250, 251, 250, 250, 250, 250, 251, 251, 243, 230
        };
        int[] g = {
            156, 165, 176, 184, 190, 196, 193, 184, 171, 162, 146, 125, 107, 93,
            81, 87, 92, 97, 95, 93, 93, 90, 85, 69, 64, 54, 47, 35, 19, 0, 4, 0
        };
        int[] b = {
            140, 147, 158, 166, 170, 176, 209, 220, 234, 225, 236, 246, 250, 251,
            250, 250, 245, 230, 230, 222, 202, 180, 163, 142, 123, 114, 106, 94,
            84, 64, 26, 27
        };
        int n = r.length;
        byte[] reds = new byte[n];
        byte[] greens = new byte[n];
        byte[] blues = new byte[n];
        for (int i = 0; i < n; i++) {
            reds[i] = (byte) r[i];
            greens[i] = (byte) g[i];
            blues[i] = (byte) b[i];
        }
        return new IndexColorModel(8, n, reds, greens, blues);
    }

    public static IndexColorModel getSpectrum() {
        Color c;
        int n = 256;
        byte[] reds = new byte[n];
        byte[] greens = new byte[n];
        byte[] blues = new byte[n];
        for (int i = 0; i < n; i++) {
            c = Color.getHSBColor(i / 255f, .5f, 1f);
            reds[i] = (byte) c.getRed();
            greens[i] = (byte) c.getGreen();
            blues[i] = (byte) c.getBlue();
        }
        return new IndexColorModel(8, n, reds, greens, blues);
    }


    public static IndexColorModel getIndexColorModel(
            int[] r, int[] g, int[] b) {
        byte[] reds = new byte[r.length];
        byte[] greens = new byte[r.length];
        byte[] blues = new byte[r.length];
        for (int i = 0; i < r.length; i++) {
            reds[i] = (byte) r[i];
            greens[i] = (byte) g[i];
            blues[i] = (byte) b[i];
        }
        return new IndexColorModel(8, 256, reds, greens, blues);
    }

    public Image getImage() {
        return getImage(pixels, size, indexColorModel);
    }

    public static Image getImage(
            byte[] pixels8, Dimension d,
            IndexColorModel indexColorModel) {

        final Toolkit tk = Toolkit.getDefaultToolkit();
        final MemoryImageSource mis = new MemoryImageSource(
                d.width,
                d.height,
                indexColorModel,
                pixels8,
                0,
                d.width);
        return tk.createImage(mis);
    }

    public void drawSquare(int x, int y, int size) {
        for (int i=x; i < x+size; i++){
            for (int j=y; j < y + size; j++){
                int n = i+j*this.size.width;
                if (n>0 && n < pixels.length)
                    pixels[n] = (byte)255;
            }
        }
    }

    public IndexColorModel getIndexColorModel() {
        return indexColorModel;
    }

    public void setIndexColorModel(IndexColorModel indexColorModel) {
        this.indexColorModel = indexColorModel;
    }

    public Dimension getSize() {
        return size;
    }
}
