/*
 * Created by DocJava, Inc.
 * User: lyon
 * Date: Mar 2, 2003
 * Time: 5:12:56 PM
 */
package j2d.color;

import gui.run.RunSlider;
import j2d.ImageProcessListener;
import j2d.hpp.HppFilterImageProcessor;

import javax.swing.*;
import java.awt.*;


public class ColorizerPanel
        extends JPanel {
    private double ar = 0.01;
    private double ag = 0.01;
    private double ab = 0.01;
    ImageProcessListener ipl = null;


    public ColorizerPanel(ImageProcessListener _ipl) {
        ipl = _ipl;

        setLayout(new FlowLayout());
        add(new RunSlider() {
            public void run() {
                ar = scaleSlider(getValue());
                updateImage();
            }
        });
        add(new RunSlider() {
            public void run() {
                ag = scaleSlider(getValue());
                updateImage();
            }
        });
        add(new RunSlider() {
            public void run() {
                ab = scaleSlider(getValue());
                updateImage();
            }
        });
    }

    private void updateImage() {
        PseudoColorFilter pcf = new PseudoColorFilter(ar, ag, ab);
        ipl.update(new HppFilterImageProcessor(pcf));

    }

    public static double scaleSlider(int t) {
        return 0.49 * (t / 100.0) + 0.01;
    }
}
