package j2d.color;

import j2d.ImageProcessorInterface;
import j2d.ShortImageBean;

import java.awt.*;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Apr 25, 2005
 * Time: 12:27:12 PM
 * Copyright DocJava, 2005
 */
public class ColorSafe implements ImageProcessorInterface {
    private int colors[] = {
        0x000000,
        0x003300,
        0x006600,
        0x009900,
        0x00CC00,
        0x00FF00,
        0x000033,
        0x003333,
        0x006633,
        0x009933,
        0x00CC33,
        0x00FF33,
        0x000066,
        0x003366,
        0x006666,
        0x009966,
        0x00CC66,
        0x00FF66,
        0x000099,
        0x003399,
        0x006699,
        0x009999,
        0x00CC99,
        0x00FF99,
        0x0000CC,
        0x0033CC,
        0x0066CC,
        0x0099CC,
        0x00CCCC,
        0x00FFCC,
        0x0000FF,
        0x0033FF,
        0x0066FF,
        0x0099FF,
        0x00CCFF,
        0x00FFFF,
        0x330000,
        0x333300,
        0x336600,
        0x339900,
        0x33CC00,
        0x33FF00,
        0x330033,
        0x333333,
        0x336633,
        0x339933,
        0x33CC33,
        0x33FF33,
        0x330066,
        0x333366,
        0x336666,
        0x339966,
        0x33CC66,
        0x33FF66,
        0x330099,
        0x333399,
        0x336699,
        0x339999,
        0x33CC99,
        0x33FF99,
        0x3300CC,
        0x3333CC,
        0x3366CC,
        0x3399CC,
        0x33CCCC,
        0x33FFCC,
        0x3300FF,
        0x3333FF,
        0x3366FF,
        0x3399FF,
        0x33CCFF,
        0x33FFFF,
        0x660000,
        0x663300,
        0x666600,
        0x669900,
        0x66CC00,
        0x66FF00,
        0x660033,
        0x663333,
        0x666633,
        0x669933,
        0x66CC33,
        0x66FF33,
        0x660066,
        0x663366,
        0x666666,
        0x669966,
        0x66CC66,
        0x66FF66,
        0x660099,
        0x663399,
        0x666699,
        0x669999,
        0x66CC99,
        0x66FF99,
        0x6600CC,
        0x6633CC,
        0x6666CC,
        0x6699CC,
        0x66CCCC,
        0x66FFCC,
        0x6600FF,
        0x6633FF,
        0x6666FF,
        0x6699FF,
        0x66CCFF,
        0x66FFFF,
        0x990000,
        0x993300,
        0x996600,
        0x999900,
        0x99CC00,
        0x99FF00,
        0x990033,
        0x993333,
        0x996633,
        0x999933,
        0x99CC33,
        0x99FF33,
        0x990066,
        0x993366,
        0x996666,
        0x999966,
        0x99CC66,
        0x99FF66,
        0x990099,
        0x993399,
        0x996699,
        0x999999,
        0x99CC99,
        0x99FF99,
        0x9900CC,
        0x9933CC,
        0x9966CC,
        0x9999CC,
        0x99CCCC,
        0x99FFCC,
        0x9900FF,
        0x9933FF,
        0x9966FF,
        0x9999FF,
        0x99CCFF,
        0x99FFFF,
        0xCC0000,
        0xCC3300,
        0xCC6600,
        0xCC9900,
        0xCCCC00,
        0xCCFF00,
        0xCC0033,
        0xCC3333,
        0xCC6633,
        0xCC9933,
        0xCCCC33,
        0xCCFF33,
        0xCC0066,
        0xCC3366,
        0xCC6666,
        0xCC9966,
        0xCCCC66,
        0xCCFF66,
        0xCC0099,
        0xCC3399,
        0xCC6699,
        0xCC9999,
        0xCCCC99,
        0xCCFF99,
        0xCC00CC,
        0xCC33CC,
        0xCC66CC,
        0xCC99CC,
        0xCCCCCC,
        0xCCFFCC,
        0xCC00FF,
        0xCC33FF,
        0xCC66FF,
        0xCC99FF,
        0xCCCCFF,
        0xCCFFFF,
        0xFF0000,
        0xFF3300,
        0xFF6600,
        0xFF9900,
        0xFFCC00,
        0xFFFF00,
        0xFF0033,
        0xFF3333,
        0xFF6633,
        0xFF9933,
        0xFFCC33,
        0xFFFF33,
        0xFF0066,
        0xFF3366,
        0xFF6666,
        0xFF9966,
        0xFFCC66,
        0xFFFF66,
        0xFF0099,
        0xFF3399,
        0xFF6699,
        0xFF9999,
        0xFFCC99,
        0xFFFF99,
        0xFF00CC,
        0xFF33CC,
        0xFF66CC,
        0xFF99CC,
        0xFFCCCC,
        0xFFFFCC,
        0xFF00FF,
        0xFF33FF,
        0xFF66FF,
        0xFF99FF,
        0xFFCCFF,
        0xFFFFFF
    };

    public ColorSafe() {
        initBrightnessTable();
    }

    private Vector brightnessVectorArray[] = new Vector[16];

    // colors sorted by brightness
    public int getBrightness(Color c) {
        int i = (c.getRed() + c.getGreen() + c.getBlue()) / 3;
        return i >> 4;
    }

    public void printLutByBrightness() {
        for (int i = 0; i < brightnessVectorArray.length; i++) {
            System.out.println("____\nbrightness=" + i);
            print(getColors(i));
        }
    }

    private void print(Object o[]) {
        for (int i = 0; i < o.length; i++)
            System.out.println(o[i]);
    }

    /**
     * @param brightness a number that ranges from 0..16
     * @return all colors of a given brightness
     */
    public Color[] getColors(int brightness) {
        Vector v = brightnessVectorArray[brightness];
        Color ca[] = new Color[v.size()];
        v.copyInto(ca);
        return ca;
    }

    public void printLutBrightness() {
        Color ca[] = getLut();
        for (int i = 0; i < ca.length; i++)
            System.out.println(getBrightness(ca[i]));
    }

    public void initBrightnessTable() {
        Color ca[] = getLut();

        for (int i = 0; i < ca.length; i++) {
            int brightness = getBrightness(ca[i]);
            Vector v = brightnessVectorArray[brightness];
            if (v == null) {
                v = new Vector();
                brightnessVectorArray[brightness] = v;
            }
            v.addElement(ca[i]);
        }
    }

    public Color[] getLut() {
        Color ca[] = new Color[colors.length];
        Vector v = new Vector();
        for (int i = 0; i < colors.length; i++)
            v.addElement(new Color(colors[i]));
        Collections.sort(v, new Comparator() {
            public int compare(Object o1, Object o2) {
                return getBrightness((Color) o1) - getBrightness((Color) o2);
            }
        });
        v.copyInto(ca);
        return ca;
    }

    public int getLutSize() {
        return colors.length;
    }

    /**
     * get the closest Color that is color safe;
     *
     * @param c
     * @return color safe color
     */
    Color getColor(Color c) {
        int b = getBrightness(c);
        Color ca[] = getColors(b);
        return getClosestColor(c, ca);
    }

    /**
     * Given an array of colors, select the one that is closest and return it.
     *
     * @param c  color to be mapped
     * @param ca colors of the same general brightness.
     * @return the color in ca that is closest
     */
    private Color getClosestColor(Color c, Color[] ca) {
        int distance = Integer.MAX_VALUE;
        Color bestMatch = ca[0];
        for (int i = 0; i < ca.length; i++) {
            int v = colorDistance(c, ca[i]);
            if (v < distance) {
                distance = v;
                bestMatch = ca[i];
            }
        }
        return bestMatch;
    }

    /**
     * Is this the best way to compute color distance?
     * //todo you might try a different color metric.
     *
     * @param c1
     * @param c2
     * @return
     */
    private int colorDistance(Color c1, Color c2) {
        int dr = c1.getRed() - c2.getRed();
        int dg = c1.getGreen() - c2.getGreen();
        int db = c1.getBlue() - c2.getBlue();
        return dr * dr + dg * dg + db * db;
    }

    public static void main(String[] args) {
        ColorSafe cs = new ColorSafe();
        cs.printLutByBrightness();


    }

    // todo
    public Image process(Image image) {

        ShortImageBean sib = new ShortImageBean(image);
        ShortImageBean output = new ShortImageBean(sib.getWidth(), sib.getHeight());
        for (int x = 0; x < sib.getWidth(); x++)
            for (int y = 0; y < sib.getHeight(); y++) {
                Color c = new Color(sib.getR()[x][y], sib.getG()[x][y], sib.getB()[x][y]);
                Color nc = getColor(c);
                output.getR()[x][y] = (short) nc.getRed();
                output.getG()[x][y] = (short) nc.getGreen();
                output.getB()[x][y] = (short) nc.getBlue();
            }

        return output.getImage();
    }
}