package j2d.animation;

import gui.run.RunButton;
import gui.run.RunSlider;
import j2d.*;

import javax.swing.*;
import java.awt.*;


public class AnimationPanel extends JPanel {


    private int speedFps = 3;
    private boolean isRunning = false;

    private Runnable r = null;
    private Image ia[] = null;
    private ImageSequenceProcessorDisplayController
            ispdc = null;

    ImageProcessListener ipl = null;

    public void openGifs() {
        ia = GifUtils.getGifs();
        ispdc = new ImageSequenceProcessorDisplayController(ia);
    }

    /**Construct the frame*/
    public AnimationPanel(ImageProcessListener _ipl) {
        ipl = _ipl;
        initGuiElements();

    }

    private JPanel getButtonPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        jp.add(new RunButton("nextImage") {
            public void run() {
                updateImage();
            }
        });
        jp.add(new RunButton("open gifs") {
            public void run() {
                openGifs();
            }
        });
        jp.add(new RunButton("save gifs") {
            public void run() {
                j2d.animation.GifUtils.writeGifStills(ia);
            }
        });
        jp.add(new RunButton("Reset") {
            public void run() {
                ipl.update(null);
            }
        });
        jp.add(new RunButton("start/stop") {
            public void run() {
                isRunning = !isRunning;
                System.out.println("isRunning=" + isRunning);
                if (isRunning)
                    r = new UpdateRunner();
                else
                    r = null;
            }
        });

        return jp;
    }


    /**Component initialization*/
    private void initGuiElements() {
        RunSlider rs[] = {
            RunSlider.getLabeledSlider("speed",
                    new RunSlider(3, 40, 15) {
                        public void run() {
                            speedFps = getValue();
                        }
                    })};

        JPanel labelPanel = new JPanel();
        JPanel sliderPanel = new JPanel();
        labelPanel.setLayout(new FlowLayout());
        sliderPanel.setLayout(new FlowLayout());
        for (int i = 0; i < rs.length; i++) {
            labelPanel.add(rs[i].getValueLabel());
            sliderPanel.add(rs[i]);
        }
        setLayout(new BorderLayout());
        add(labelPanel, BorderLayout.EAST);
        add(sliderPanel, BorderLayout.CENTER);
        add(getButtonPanel(), BorderLayout.SOUTH);

    }

    public JPanel getComparisonPanel(ImageProcessorFactory ipf) {

        ImageBeanInterface origImagePanel =
                (ImageBeanInterface) ipl;
        Image sourceImage = origImagePanel.getImage();
        return ComparisonUtils.getComparisonPanel(
                sourceImage, ipf);

    }

    public void updateImage(ImageProcessorInterface ip) {
        ipl.update(ip);
    }

    public void updateImage() {
        if (ispdc == null) openGifs();
        //ipl.update(ispdc);
        ipl.setImage(ispdc.process(null));
    }

    private class UpdateRunner implements Runnable {
        Thread t = new Thread(this);

        public UpdateRunner() {
            t.start();
        }

        public void run() {
            while (isRunning) {
                updateImage();
                try {
                    long l = (long) (1000.0 / speedFps);
                    Thread.sleep(l);
                    System.out.println("next image in:" + l);
                } catch (InterruptedException e) {
                }
            }
        }
    }


}
