// Decompiled by Jad v1.5.8c. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.geocities.com/kpdus/jad.html
// Decompiler options: packfields(3) packimports(7) deadcode fieldsfirst splitstr(64) nonlb lnc radix(10) lradix(10) 
// Source File Name:   KernelJAI.java

package j2d;

import java.awt.image.Kernel;
import java.io.Serializable;

// Referenced classes of package javax.media.jai:
//            JaiI18N

public class KernelJAI
        implements Serializable {

    public static final KernelJAI ERROR_FILTER_FLOYD_STEINBERG = new KernelJAI(
            3, 2, 1, 0, new float[]{
/*  56*/        0.0F, 0.0F, 0.4375F, 0.1875F, 0.3125F, 0.0625F
            });
    public static final KernelJAI ERROR_FILTER_JARVIS = new KernelJAI(
            5, 3, 2, 0, new float[]{
/*  69*/        0.0F, 0.0F, 0.0F, 0.1458333F, 0.1041667F, 0.0625F, 0.1041667F, 0.1458333F, 0.1041667F, 0.0625F,
/*  69*/        0.02083333F, 0.0625F, 0.1041667F, 0.0625F, 0.02083333F
            });
    public static final KernelJAI ERROR_FILTER_STUCKI = new KernelJAI(
            5, 3, 2, 0, new float[]{
/*  83*/        0.0F, 0.0F, 0.0F, 0.1666667F, 0.1190476F, 0.04761905F, 0.0952381F, 0.1904762F, 0.0952381F, 0.04761905F,
/*  83*/        0.02380952F, 0.04761905F, 0.0952381F, 0.04761905F, 0.02380952F
            });
    public static final KernelJAI DITHER_MASK_441[] = {
/*  92*/        new KernelJAI(
        4, 4, 1, 1, new float[]{
/*  92*/            0.9375F, 0.4375F, 0.8125F, 0.3125F, 0.1875F, 0.6875F, 0.0625F, 0.5625F, 0.75F, 0.25F,
/*  92*/            0.875F, 0.375F, 0.0F, 0.5F, 0.125F, 0.625F
        })
    };
    public static final KernelJAI DITHER_MASK_443[] = {
/* 104*/        new KernelJAI(
        4, 4, 1, 1, new float[]{
/* 104*/            0.0F, 0.5F, 0.125F, 0.625F, 0.75F, 0.25F, 0.875F, 0.375F, 0.1875F, 0.6875F,
/* 104*/            0.0625F, 0.5625F, 0.9375F, 0.4375F, 0.8125F, 0.3125F
        }), new KernelJAI(
                4, 4, 1, 1, new float[]{
/* 104*/            0.625F, 0.125F, 0.5F, 0.0F, 0.375F, 0.875F, 0.25F, 0.75F, 0.5625F, 0.0625F,
/* 104*/            0.6875F, 0.1875F, 0.3125F, 0.8125F, 0.4375F, 0.9375F
                }), new KernelJAI(
                        4, 4, 1, 1, new float[]{
/* 104*/            0.9375F, 0.4375F, 0.8125F, 0.3125F, 0.1875F, 0.6875F, 0.0625F, 0.5625F, 0.75F, 0.25F,
/* 104*/            0.875F, 0.375F, 0.0F, 0.5F, 0.125F, 0.625F
                        })
    };
    public static final KernelJAI GRADIENT_MASK_SOBEL_VERTICAL = new KernelJAI(
            3, 3, 1, 1, new float[]{
/* 125*/        -1F, -2F, -1F, 0.0F, 0.0F, 0.0F, 1.0F, 2.0F, 1.0F
            });
    public static final KernelJAI GRADIENT_MASK_SOBEL_HORIZONTAL = new KernelJAI(
            3, 3, 1, 1, new float[]{
/* 134*/        -1F, 0.0F, 1.0F, -2F, 0.0F, 2.0F, -1F, 0.0F, 1.0F
            });
    protected int width, height, xOrigin, yOrigin;
    protected float data[], dataH[], dataV[];
    protected boolean isSeparable, isHorizontallySymmetric, isVerticallySymmetric;
    protected KernelJAI rotatedKernel;

    private synchronized void checkSeparable() {
/* 177*/        float floatZeroTol = 1E-05F;
/* 179*/        if (isSeparable)
/* 179*/
    return;
/* 180*/        if (width <= 1 || height <= 1)
/* 180*/
    return;
/* 192*/        float maxData = 0.0F;
/* 193*/        int imax = 0;
/* 193*/        int jmax ;
/* 195*/        for (int k = 0; k < data.length; k++) {
/* 196*/            float tmp = Math.abs(data[k]);
/* 197*/            if (tmp > maxData) {
/* 198*/                imax = k;
/* 199*/                maxData = tmp;
}
}

/* 206*/        if (maxData < floatZeroTol / (float) data.length) {
/* 207*/            isSeparable = false;
/* 208*/            return;
}
/* 211*/        float tmpRow[] = new float[width];
/* 212*/        float fac = 1.0F / data[imax];
/* 215*/        jmax = imax % width;
/* 216*/        imax /= width;
/* 219*/        for (int j = 0; j < width; j++)
/* 220*/
    tmpRow[j] = data[imax * width + j] * fac;

/* 226*/        int i = 0;
/* 226*/        for (int i0 = 0; i < height; i0 += width) {
/* 227*/            for (int j = 0; j < width; j++) {
/* 228*/                float tmp = Math.abs(
        data[i0 + jmax] * tmpRow[j] - data[i0 + j]);
/* 229*/                if (tmp > floatZeroTol) {
/* 230*/                    isSeparable = false;
/* 231*/                    return;
}
}

/* 226*/            i++;
}

/* 237*/        dataH = tmpRow;
/* 238*/        dataV = new float[height];
/* 239*/        for (i = 0; i < height; i++)
/* 240*/
    dataV[i] = data[jmax + i * width];

/* 242*/        isSeparable = true;
/* 251*/        float sumH = 0.0F;
/* 251*/        float sumV = 0.0F;
/* 252*/        for (int j = 0; j < width; j++)
/* 252*/
    sumH += dataH[j];

/* 253*/        for (int j = 0; j < height; j++)
/* 253*/
    sumV += dataV[j];

/* 255*/        if (Math.abs(sumH) >= Math.abs(sumV) &&
        Math.abs(sumH) > floatZeroTol) {
/* 256*/            fac = 1.0F / sumH;
/* 257*/            for (int j = 0; j < width; j++)
/* 257*/
    dataH[j] *= fac;

/* 258*/            for (int j = 0; j < height; j++)
/* 258*/
    dataV[j] *= sumH;

} else
/* 259*/ if (Math.abs(sumH) < Math.abs(sumV) &&
        Math.abs(sumV) > floatZeroTol) {
/* 261*/            fac = 1.0F / sumV;
/* 262*/            for (int j = 0; j < width; j++)
/* 262*/
    dataH[j] *= sumV;

/* 263*/            for (int j = 0; j < height; j++)
/* 263*/
    dataV[j] *= fac;

}
    }

    private void classifyKernel() {
/* 270*/        if (!isSeparable)
/* 271*/
    checkSeparable();
/* 273*/        isHorizontallySymmetric = false;
/* 274*/        isVerticallySymmetric = false;
    }

    public KernelJAI(
            int width,
            int height,
            int xOrigin,
            int yOrigin,
            float data[]) {
/* 153*/        this.data = null;
/* 156*/        dataH = null;
/* 159*/        dataV = null;
/* 162*/        isSeparable = false;
/* 165*/        isHorizontallySymmetric = false;
/* 168*/        isVerticallySymmetric = false;
/* 171*/        rotatedKernel = null;
/* 300*/        if (data == null)
/* 301*/
    throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
/* 304*/        this.width = width;
/* 305*/        this.height = height;
/* 306*/        this.xOrigin = xOrigin;
/* 307*/        this.yOrigin = yOrigin;
/* 308*/        this.data = (float[]) data.clone();
/* 309*/        if (width <= 0)
/* 310*/
    throw new IllegalArgumentException(
            j2d.JaiI18N.getString("KernelJAI0"));
/* 312*/        if (height <= 0)
/* 313*/
    throw new IllegalArgumentException(JaiI18N.getString("KernelJAI1"));
/* 315*/        if (width * height != data.length) {
/* 316*/            throw new IllegalArgumentException(
        JaiI18N.getString("KernelJAI2"));
} else {
/* 318*/            classifyKernel();
}
    }

    public KernelJAI(
            int width,
            int height,
            int xOrigin,
            int yOrigin,
            float dataH[],
            float dataV[]) {
/* 153*/        data = null;
/* 156*/        this.dataH = null;
/* 159*/        this.dataV = null;
/* 162*/        isSeparable = false;
/* 165*/        isHorizontallySymmetric = false;
/* 168*/        isVerticallySymmetric = false;
/* 171*/        rotatedKernel = null;
/* 351*/        if (dataH == null || dataV == null)
/* 352*/
    throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
/* 355*/        if (width <= 0)
/* 356*/
    throw new IllegalArgumentException(JaiI18N.getString("KernelJAI0"));
/* 359*/        if (height <= 0)
/* 360*/
    throw new IllegalArgumentException(JaiI18N.getString("KernelJAI1"));
/* 363*/        if (width != dataH.length)
/* 364*/
    throw new IllegalArgumentException(JaiI18N.getString("KernelJAI3"));
/* 367*/        if (height != dataV.length)
/* 368*/
    throw new IllegalArgumentException(JaiI18N.getString("KernelJAI4"));
/* 371*/        this.width = width;
/* 372*/        this.height = height;
/* 373*/        this.xOrigin = xOrigin;
/* 374*/        this.yOrigin = yOrigin;
/* 375*/        this.dataH = (float[]) dataH.clone();
/* 376*/        this.dataV = (float[]) dataV.clone();
/* 377*/        data = new float[dataH.length * dataV.length];
/* 379*/        int rowOffset = 0;
/* 380*/        for (int i = 0; i < dataV.length; i++) {
/* 381*/            float vValue = dataV[i];
/* 382*/            for (int j = 0; j < dataH.length; j++)
/* 383*/
    data[rowOffset + j] = vValue * dataH[j];

/* 385*/            rowOffset += dataH.length;
}

/* 387*/        isSeparable = true;
/* 388*/        classifyKernel();
    }

    public KernelJAI(int width, int height, float data[]) {
/* 407*/        this(width, height, width / 2, height / 2, data);
    }

    public KernelJAI(Kernel k) {
/* 418*/        this(
        k.getWidth(),
        k.getHeight(),
        k.getXOrigin(),
        k.getYOrigin(),
        k.getKernelData(null));
    }

    public int getWidth() {
/* 424*/        return width;
    }

    public int getHeight() {
/* 429*/        return height;
    }

    public int getXOrigin() {
/* 434*/        return xOrigin;
    }

    public int getYOrigin() {
/* 439*/        return yOrigin;
    }

    public float[] getKernelData() {
/* 444*/        return (float[]) data.clone();
    }

    public float[] getHorizontalKernelData() {
/* 453*/        if (dataH == null)
/* 454*/
    return null;
/* 456*/
else
/* 456*/
    return (float[]) dataH.clone();
    }

    public float[] getVerticalKernelData() {
/* 465*/        if (dataV == null)
/* 466*/
    return null;
/* 468*/
else
/* 468*/
    return (float[]) dataV.clone();
    }

    public float getElement(int xIndex, int yIndex) {
/* 478*/        if (!isSeparable)
/* 479*/
    return data[yIndex * width + xIndex];
/* 481*/
else
/* 481*/
    return dataH[xIndex] * dataV[yIndex];
    }

    public boolean isSeparable() {
/* 489*/        return isSeparable;
    }

    public boolean isHorizontallySymmetric() {
/* 494*/        return isHorizontallySymmetric;
    }

    public boolean isVerticallySymmetric() {
/* 499*/        return isVerticallySymmetric;
    }

    public int getLeftPadding() {
/* 506*/        return xOrigin;
    }

    public int getRightPadding() {
/* 513*/        return width - xOrigin - 1;
    }

    public int getTopPadding() {
/* 520*/        return yOrigin;
    }

    public int getBottomPadding() {
/* 527*/        return height - yOrigin - 1;
    }

    public KernelJAI getRotatedKernel() {
/* 537*/        if (rotatedKernel == null)
/* 538*/
    if (isSeparable) {
/* 539*/                float rotDataH[] = new float[width];
/* 540*/                float rotDataV[] = new float[height];
/* 541*/                for (int i = 0; i < width; i++)
/* 542*/
    rotDataH[i] = dataH[width - 1 - i];

/* 544*/                for (int i = 0; i < height; i++)
/* 545*/
    rotDataV[i] = dataV[height - 1 - i];

/* 547*/                rotatedKernel
        = new KernelJAI(
                width,
                height,
                width - 1 - xOrigin,
                height - 1 - yOrigin,
                rotDataH,
                rotDataV);
    } else {
/* 555*/                int length = data.length;
/* 556*/                float newData[] = new float[data.length];
/* 557*/                for (int i = 0; i < length; i++)
/* 558*/
    newData[i] = data[length - 1 - i];

/* 560*/                rotatedKernel
        = new KernelJAI(
                width,
                height,
                width - 1 - xOrigin,
                height - 1 - yOrigin,
                newData);
    }
/* 568*/        return rotatedKernel;
    }

}
