package ip.transforms;

import graphics.NumImage;
import gui.ClosableJFrame;
import j2d.ImagePanel;
import j2d.ImageUtils;
import j2d.ShortImageBean;
import math.Mat2;
import math.MathUtils;

import java.awt.*;
import java.awt.image.ImageObserver;
import java.io.File;


public class ConvolutionUtils {
    static double t0 = 0;
    static double t1 = 0;
    static double t2 = 0;
    static double t3 = 0;
    static double t4 = 0;
    static double t5 = 0;
    static double t6 = 0;
    static double t7 = 0;
    static double t8 = 0;
    static double t9 = 0;
    static double t10 = 0;
    static double t11 = 0;
    static double t12 = 0;
    static double t13 = 0;
    static double t14 = 0;
    static double t15 = 0;
    static double t16 = 0;
    static double t17 = 0;
    static double t18 = 0;
    static double t19 = 0;
    static double t20 = 0;
    static double t21 = 0;
    static double t22 = 0;
    static double t23 = 0;
    static double t24 = 0;
    static double t25 = 0;
    static double t26 = 0;
    static double t27 = 0;
    static double t28 = 0;
    static double t29 = 0;
    static double t30 = 0;
    static double t31 = 0;
    static double t32 = 0;
    static double t33 = 0;
    static double t34 = 0;
    static double t35 = 0;
    static double t36 = 0;
    static double t37 = 0;
    static double t38 = 0;
    static double t39 = 0;
    static double t40 = 0;
    static double t41 = 0;
    static double t42 = 0;
    static double t43 = 0;

    public static void drawPel(Graphics g, int x, int y) {
        int dGrid = 10;
        int x1 = x * dGrid;
        int y1 = y * dGrid;
        int h = dGrid / 2;
        g.drawOval(x1 - h, y1 - h, dGrid, dGrid);
    }

    public static void drawPel(Graphics g, Point p) {
        drawPel(g, p.x, p.y);
    }

    public static void testConvolution() {
        File f = new File("Users/lyon/current/java/j4p/dataFiles/images/orl_faces/assortment/jpg/s6_11.jpg");
        System.out.println(f);
        Image img = ImageUtils.getGifJpgPngImage(f);
        ImageUtils.convolution(img, Kernels.getLaplacian9());

    }

    public static void oddTest() {
        System.out.println("24 is odd:" + MathUtils.odd(24) +
                " 13 is odd:" + MathUtils.odd(13));
    }

    public static Image convolution(Image img, float k[][], ImageObserver io) {
        short orig[][] = ImageUtils.getGreenFromImage(img, io);
        orig = Mat2.clip(ConvolutionUtils.convolve(orig, k));
        return ImageUtils.getTransposedImage(orig);
    }

    public static void main(String[] args) {
        testGrowTile();
        //testCxCy();
    }

    public static void testGrowTile() {
        Image img = NumImage.getImage();
        ImagePanel ip = new ImagePanel(img);
        ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        c.setLayout(new FlowLayout());
        c.add(ip);
        c.add(new ImagePanel(growTile(img, 70, 70)));
        cf.setSize(200, 200);
        cf.setVisible(true);
    }

    public static Image growTile(Image img, int growX, int growY) {
        ShortImageBean sib = new ShortImageBean(img);
        short r [][] = sib.getR();
        short g [][] = sib.getG();
        short b [][] = sib.getB();
        int oldWidth = sib.getWidth();
        int oldHeight = sib.getHeight();
        int newWidth = oldWidth + growX;
        int newHeight = oldHeight + growY;
        System.out.println("new Width=" + newWidth);
        System.out.println("new Height=" + newHeight);
        ShortImageBean sibNew = new ShortImageBean(newWidth, newHeight);
        short nr [][] = sibNew.getR();
        short ng [][] = sibNew.getG();
        short nb [][] = sibNew.getB();
        for (int x = 0; x < newWidth; x++) {
            for (int y = 0; y < newHeight; y++) {
                int otx = cx(x-growX/2, oldWidth);
                int oty = cy(y-growY/2, oldHeight);
                nr[x][y] = r[otx][oty];
                ng[x][y] = g[otx][oty];
                nb[x][y] = b[otx][oty];
            }
        }
        return sibNew.getImage();
    }

    public static void testCxCy() {
        int width = 3;
        int height = 3;
        int gx = 6;
        int gy = 6;
        for (int x = -gx; x < width + gx; x++) {
            for (int y = -gy; y < height + gy; y++) {
                int tx = cx(x, width);
                int ty = cy(y, height);
                System.out.print(tx + "," + ty + " ");
            }
            System.out.println();
        }
    }

    public static int cx(int x, int width) {
        if (x >= width )
            return x % width;
        if (x < 0)
            return  (width  + x % width)%width;
        return x;
    }

    public static int cy(int y, int height) {
        if (y >= height)
            return y % height;
        if (y < 0)
            return (height +  y % height)%height;
        return y;
    }

    public static short[][] convolveBruteForce(short f[][], float k[][]) {
        int uc = k.length / 2;
        int vc = k[0].length / 2;
        int width = f.length;
        int height = f[0].length;

        short h[][] = new short[width][height];

        for (int y = 0; y < height; y++) {
            for (int x = 0; x < width; x++) {
                convolvePixel(x, y, uc, vc, width, height, k, f, h);
            }
        }
        return h;
    }

    private static void convolvePixel(int x, int y,
                                      int uc, int vc,
                                      int imageWidth, int imageHeight,
                                      float[][] kernel,
                                      short[][] inputImage, short[][] outputImage) {
        double sum;
        sum = 0.0;
        for (int v = -vc; v <= vc; v++)
            for (int u = -uc; u <= uc; u++)
                sum += inputImage[cx(x - u, imageWidth)][cy(y - v, imageHeight)] * kernel[u + uc][v + vc];
        //if (sum < 0) sum = 0;
        //if (sum > 255) sum = 255;
        outputImage[x][y] = (short) sum;
    }

// Convolution, optimze the edges
    public static short[][] convolve(short f[][], float k[][]) {
        if (k == null) return null;
        if (f == null) return null;
        if (!(MathUtils.odd(k.length) && MathUtils.odd(k[0].length))) {
            System.out.println("Error:kernel passed to convolution is not odd!");

        }
        int uc = k.length / 2;
        int vc = k[0].length / 2;

        short h[][] = convolveNoEdge(f, k);
        double sum = 0;
        int width = f.length;
        int height = f[0].length;
        //convolve bottom
        for (int x = 0; x < width - 1; x++)
            for (int y = 0; y < vc; y++) {
                sum = 0.0;
                for (int v = -vc; v <= vc; v++)
                    for (int u = -uc; u <= uc; u++)
                        sum += f[cx(x - u, width)][cy(y - v, height)] * k[u + uc][v + vc];
                //if (sum < 0) sum = 0;
                //if (sum > 255) sum = 255;
                h[x][y] = (short) sum;
            }
        //convolve left
        for (int x = 0; x < uc; x++)
            for (int y = vc; y < height - vc; y++) {

                sum = 0.0;
                for (int v = -vc; v <= vc; v++)
                    for (int u = -uc; u <= uc; u++)
                        sum += f[cx(x - u, height)][cy(y - v, height)] * k[u + uc][v + vc];
                //if (sum < 0) sum = 0;
                //if (sum > 255) sum = 255;
                h[x][y] = (short) sum;
            }
        //convolve right
        for (int x = width - uc; x < width - 1; x++)
            for (int y = vc; y < height - vc; y++) {

                sum = 0.0;
                for (int v = -vc; v <= vc; v++)
                    for (int u = -uc; u <= uc; u++)
                        sum += f[cx(x - u, width)][y - v] * k[u + uc][v + vc];
                //if (sum < 0) sum = 0;
                //if (sum > 255) sum = 255;
                h[x][y] = (short) sum;
            }

        //convolve top
        try {
            for (int x = 0; x < width - 1; x++) {
                for (int y = height - vc; y < height - 1; y++) {
                    sum = 0.0;
                    for (int v = -vc; v <= vc; v++)
                        for (int u = -uc; u <= uc; u++)
                            sum += f[cx(x - u, f.length)][cy(y - v, f[0].length)]
                                    * k[u + uc][v + vc];
                    //if (sum < 0) sum = 0;
                    //if (sum > 255) sum = 255;
                    h[x][y] = (short) sum;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return h;
    }
// Convolution, ignoring the edges
    public static short[][] convolveNoEdge(short f[][], float k[][]) {
        int uc = k.length / 2;
        int vc = k[0].length / 2;
        int width = f.length;
        int height = f[0].length;
        short h[][] = new short[width][height];
        double sum = 0;

        for (int x = uc; x < width - uc; x++) {
            for (int y = vc; y < height - vc; y++) {

                sum = 0.0;
                for (int v = -vc; v <= vc; v++)
                    for (int u = -uc; u <= uc; u++)
                        sum += f[x - u][y - v] * k[u + uc][v + vc];
                //if (sum < 0) sum = 0;
                //if (sum > 255) sum = 255;
                h[x][y] = (short) sum;
            }
        }
        return h;
    }


    public static short[][] convolveBrute2(short f[][], float k[][]) {
        return convolveBruteForce(f, k);
    }

    public static short[][] convolve2(short f[][], float k[][]) {
        //return convolveNoEdge2(f, k);
        return convolveBruteForce(f, k);
    }

    public static short[][] convolveNoEdge2(short f[][], float k[][]) {
        return convolveNoEdge(f, k);

    }


}

