package ip.gui.frames;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.File;

public class SimpleImageFrame
        extends Frame
        implements ActionListener {


    private Image image;
    private ColorModel cm = ColorModel.getRGBdefault();
    private boolean imageComesFromFile = false;

    public short r[][];
    public short g[][];
    public short b[][];

    public int width = 128;
    public int height = 128;

// A default file name..set to null
// to start with file open dialog.
// Set to string to start with an image.
// Use a fully qualified path name, in quotes.
    private String fileName = null;

    private MenuBar menuBar = new MenuBar();
    Menu fileMenu = new Menu("File");

    Menu openMenu = new Menu("Open");
    MenuItem openGif_mi = addMenuItem(openMenu, "ip.gif or jpeg");
    MenuItem revert_mi = addMenuItem(openMenu, "revert");
    MenuItem fitScreen_mi = addMenuItem(openMenu, "fitScreen");


    public void fitScreen() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d
                = tk.getScreenSize();
        setSize(d.width, d.height);
    }

    public MenuItem addMenuItem(Menu aMenu, String itemName) {
        MenuItem mi = new MenuItem(itemName);
        aMenu.add(mi);
        mi.addActionListener(this);
        return (mi);
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();

        if (o == fitScreen_mi) {
            fitScreen();
            return;
        }
        if (o == openGif_mi) {
            openGif();
            return;
        }
        if (o == revert_mi) {
            revert();
            return;
        }
    }

    public SimpleImageFrame(String title) {
        super(title);
        initialize();
    }


    private void initialize() {
        initMenu();
        setVisible(true);
        setSize(width, height);
        repaint();
    }


    private void initMenu() {
        fileMenu.add(openMenu);
        menuBar.add(fileMenu);
        setMenuBar(menuBar);
    }

    protected String getReadFileName() {
        FileDialog fd = new
                FileDialog(this, "select a file");
        fd.setVisible(true);
        String file_name = fd.getFile();
        if (fd.getFile() == null) return null;
        String path_name = fd.getDirectory();
        String file_string = path_name + file_name;
        System.out.println("Opening file: " + file_string);
        fd.dispose();
        return file_string;
    }

    public void setImageResize(Image i) {
        setImage(i);

        setSize(width, height);
        setVisible(true);
        repaint();
    }

    public void setImage(Image i) {
        image = i;
        waitForImage(this, i);
        width = i.getWidth(this);
        height = i.getHeight(this);
        image2Short();
    }

    public void setImageNoShort(Image i) {
        image = i;
        waitForImage(this, i);
        width = i.getWidth(this);
        height = i.getHeight(this);
    }

    public Image getImage() {
        waitForImage(this, image);
        return image;
    }

    public String getFileName() {
        return fileName;
    }

    /**
     * short2Image - turn 3 short arrays, r, g and b into an image.
     */
    public void short2Image() {
        width = r.length;
        height = r[0].length;
        Toolkit tk = Toolkit.getDefaultToolkit();
        int pels[] = new int[width * height];
        for (int x = 0; x < width; x++)
            for (int y = 0; y < height; y++) {
                pels[x + y * width] =
                        0xff000000
                                | (r[x][y] << 16)
                                | (g[x][y] << 8)
                                | b[x][y];
            }
        Image i = tk.createImage(
                new MemoryImageSource(
                        width,
                        height,
                        cm,
                        pels, 0,
                        width));
        setImageNoShort(i);
        Rectangle r = getBounds();
        repaint(0, 0, r.width, r.height);
    }

    public void pels2Image(int pels[]) {
        width = r.length;
        height = r[0].length;
        Toolkit tk = Toolkit.getDefaultToolkit();
        Image i = tk.createImage(
                new MemoryImageSource(
                        width,
                        height,
                        cm,
                        pels, 0,
                        width));
        setImageNoShort(i);
        Rectangle r = getBounds();
        repaint(0, 0, r.width, r.height);
    }

    /**
     * image2Short - takes the private Image instance and
     * makes 3 short arrays, r, g and b.
     */
    public void image2Short() {
        r = new short[width][height];
        g = new short[width][height];
        b = new short[width][height];

        int pels[] = new int[width * height];
        cm = ColorModel.getRGBdefault();

        PixelGrabber grabber =
                new PixelGrabber(
                        image, 0, 0,
                        width, height, pels, 0, width);

        try {
            grabber.grabPixels();
        } catch (InterruptedException e) {
        }
        ;
        int i = 0;
        for (int x = 0; x < width; x++)
            for (int y = 0; y < height; y++) {
                i = x + y * width;
                b[x][y] = (short) cm.getBlue(pels[i]);
                g[x][y] = (short) cm.getGreen(pels[i]);
                r[x][y] = (short) cm.getRed(pels[i]);
            }
    }


    static void waitForImage(Component component,
                             Image image) {
        MediaTracker tracker = new MediaTracker(component);
        try {
            tracker.addImage(image, 0);
            tracker.waitForID(0);
            if (!tracker.checkID(0))
                System.out.println("Load failure!");
        } catch (InterruptedException e) {
        }
    }

    public void openGif() {
        String fn = getReadFileName();
        if (fn == null) return;
        openGif(fn);
    }

    public void setFileName(String _fn) {
        File f = new File(_fn);
        if (f.exists()) {
            fileName = _fn;
            System.out.println(
                    "File:" + fileName +
                            "\nis " + f.length() + " bytes long");
        }
        imageComesFromFile = true;

    }

    public void openGif(String fn) {
        File f = new File(fn);

        fileName = fn;
        image = Toolkit.getDefaultToolkit().getImage(
                fileName);
        setImageResize(image);
        imageComesFromFile = true;
    }

    public void revert() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (fileName == null)
            openGif();
        else {
            image =
                    tk.getImage(fileName);
            setImageResize(image);
        }

    }

    public void revertNoResize() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (fileName == null)
            openGif();
        else {
            image =
                    tk.getImage(fileName);
            setImage(image);
        }

    }

    // Takes a packed RGB model and makes
    // the short arrays
    public void int2Short(int pels[]) {
        System.out.println("The width and height are"
                + width + "," + height);
        r = new short[width][height];
        g = new short[width][height];
        b = new short[width][height];

        cm = ColorModel.getRGBdefault();
        int i = 0;
        for (int x = 0; x < width; x++)
            for (int y = 0; y < height; y++) {
                i = x + y * width;
                b[x][y] = (short) cm.getBlue(pels[i]);
                g[x][y] = (short) cm.getGreen(pels[i]);
                r[x][y] = (short) cm.getRed(pels[i]);
            }
    }


    public static void main(String args[]) {
        SimpleImageFrame imgFrm =
                new SimpleImageFrame("SimpleImageFrame");
        imgFrm.openGif();
    }

    public void paint(Graphics g) {
        if (image != null) {
            Rectangle r = getBounds();
            g.drawImage(image, 0, 0, r.width, r.height,
                    this);
        }
    }
}