package ip.gui.frames;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class FileMenuFrame extends ImageFrame implements ActionListener {
    MenuBar mb = new MenuBar();
    Menu FileMenu = getMenu("File");
    MenuItem print_mi = addMenuItem(FileMenu, "[E-p]rint");

    FileMenuFrame(String title) {
        super(title);
        mb.add(FileMenu);
        setMenuBar(mb);
    }

    public void actionPerformed(ActionEvent e) {
        if (match(e, print_mi)) {
            print(this);
            return;
        }
        super.actionPerformed(e);

    }

    public static void print(Frame f) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        PrintJob printJob =
                tk.getPrintJob(
                        f,
                        "print me!",
                        null);
        Graphics g = printJob.getGraphics();
        f.paint(g);
        printJob.end();
    }

}