package ip.gui.frames;

import futils.Ls;
import ip.gui.ImageSequence;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class AnimateFrame
        extends ShortCutFrame
        implements ActionListener {
    private String homeDir =
            "http://www.docjava.com/java/images/";
    private String roadImgs =
            homeDir + "road.imgs";

    private MenuBar menuBar = new MenuBar();
    Menu fileMenu = getMenu("File");
    Menu openMenu = getMenu("Open");
    MenuItem save_mi
            = addMenuItem(fileMenu, "save *.imgs...");
    MenuItem open_mi
            = addMenuItem(openMenu, "*.imgs...");
    MenuItem openGifs_mi
            = addMenuItem(openMenu, "*.gifs...");
    MenuItem openRoadImgs_mi
            = addMenuItem(openMenu, roadImgs);
    MenuItem start_mi
            = addMenuItem(fileMenu, "start");
    MenuItem stop_mi
            = addMenuItem(fileMenu, "stop");
    MenuItem fhaar_mi
            = addMenuItem(fileMenu, "forward haar");
    MenuItem bhaar_mi
            = addMenuItem(fileMenu, "backward haar");


    public boolean running = true;
    private ImageSequence imgSeq
            = new ImageSequence();


    public void setRunning(boolean t) {
        running = t;
    }


    public void actionPerformed(ActionEvent e) {
        Object c = e.getSource();

        if (c == fhaar_mi) {
            fhaar();
            return;
        }
        if (c == bhaar_mi) {
            bhaar();
            return;
        }
        if (c == openRoadImgs_mi) {
            openRoadImgs();
            return;
        }
        if (c == save_mi) {
            saveImages();
            return;
        }
        if (c == open_mi) {
            openImages();
            return;
        }
        if (c == openGifs_mi) {
            openGifs();
            return;
        }
        if (c == start_mi) {
            setRunning(true);
            return;
        }
        if (c == stop_mi) {
            setRunning(false);
            return;
        }

    }

    public AnimateFrame() {
        super("AnimateFrame");
        fileMenu.add(openMenu);
        menuBar.add(fileMenu);
        setMenuBar(menuBar);
        setSize(64, 64);
    }

    public void fhaar() {
        setRunning(false);
        imgSeq.forwardHaar();
        setRunning(true);
    }

    public void bhaar() {
        imgSeq.backwardHaar();
    }

    public void saveImages() {
        imgSeq.save();
    }

    public void openImages() {
        imgSeq.open();
        setVisible(true);
    }

    public void openRoadImgs() {
        try {
            imgSeq.open(
                    new URL(roadImgs));
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }
        setSize(imgSeq.getWidth(), imgSeq.getHeight());
        setVisible(true);
        setRunning(true);
    }

    public void addImage(Image img) {
        imgSeq.add(img);
        imgSeq.setWidth(img.getWidth(this));
        imgSeq.setHeight(img.getHeight(this));
    }

    public void update(Graphics g) {
        paint(g);
    }


    public void paint(Graphics g) {
        if (imgSeq.getSize() == 0) return;
        if (!running) return;
        Rectangle r = getBounds();
        g.drawImage(imgSeq.next(), 0, 0, r.width, r.height,
                this);
        repaint(33);
    }

    void waitForImage(Component component,
                      Image image) {
        MediaTracker tracker = new MediaTracker(component);
        try {
            tracker.addImage(image, 0);
            tracker.waitForID(0);
            if (!tracker.checkID(0))
                System.out.println("Load failure!");
        } catch (InterruptedException e) {
        }
    }

    public void openGifs(File fileNames[]) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        for (int i = 0; i < fileNames.length; i++) {
            Image img = tk.getImage(fileNames[i].toString());
            waitForImage(this, img);
            addImage(img);
        }
        setVisible(true);
    }

    public void openGifs() {
        File files[] = Ls.getWildFiles("gif");
        openGifs(files);
        setSize(imgSeq.getWidth(),
                imgSeq.getHeight());
    }

}
