package ip.apurva;


public class SPxform {

    public static short[][] transpose(short in[][]) {
        int width = in.length;
        int height = in[0].length;
        short[][] output = new short[height][width];

        for (int j = 0; j < width; j++)
            for (int i = 0; i < height; i++)
                output[j][i] = in[i][j];

        return output;
    }

    public static void S_plus_P_Xform(short in[][]) {
        for (int x = 0; x < in.length; x++)
            SPxform(in[x], in.length);
        in = transpose(in);
        for (int x = 0; x < in.length; x++)
            SPxform(in[x], in.length);
        in = transpose(in);

    }

    public static void SPxform(short in[], int n) {
        int i;
        if (n < 2) return;
        int nOn2 = n / 2;
        short s[] = new short[nOn2];
        short d[] = new short[nOn2];
        short delta[] = new short[in.length];

        for (i = 0; i < nOn2; i++) {
            s[i] = in[2 * i];
            d[i] = in[2 * i + 1];
        }

        for (i = 1; i < s.length; i++)
            delta[i] = (short) (s[i - 1] - s[i]);

        for (i = 1; i < s.length - 1; i++) {
            d[i] = (short) (d[i] + 0 * delta[i - 1] + 1 / 4 * delta[i] + 3 / 8 * delta[i + 1] - 1 / 4 * d[i + 1]);

        }

        for (i = 0; i < s.length; i++) {
            in[i] = s[i];
            in[i + nOn2] = d[i];
        }
        SPxform(in, nOn2);
    }
//i was trying to write inverse s+p xform code here code here
    public static void inversXform(short in[][]) {
        for (int x = 0; x < in.length; x++)
            inverseform(in[x]);
        in = transpose(in);
        for (int x = 0; x < in.length; x++)
            inverseform(in[x]);
        in = transpose(in);

    }

    public static void inverseform(short in[]) {
        int i;
        int n = in.length;
        if (n < 2) return;
        int nOn2 = n / 2;
        short s[] = new short[nOn2];
        short delta[] = new short[nOn2];
        for (i = 0; i < nOn2; i++)
            s[i] = in[i];
        inverseform(s);
        nOn2 = in.length / 2;
        short d[] = new short[nOn2];
        for (i = 0; i < d.length; i++)
            d[i] = in[i + nOn2];

        for (i = 1; i < s.length; i++)
            delta[i] = (short) (s[i - 1] - s[i]);

        for (i = 1; i < s.length - 1; i++) {
            d[i] = (short) (d[i] - 0 * delta[i - 1] - 1 / 4 * delta[i] - 3 / 8 * delta[i + 1] + 1 / 4 * d[i + 1]);
        }
        for (i = 0; i < s.length; i++) {
            in[2 * i] = s[i];
            in[2 * i + 1] = d[i];
        }
    }
}