package gui.tree;

import javax.swing.*;
import java.awt.*;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.*;
import java.util.Iterator;

public class JLabelDragSource implements DragGestureListener,
        DragSourceListener {
    public JLabelDragSource(JLabel label) {
        this.label = label;

        // Use the default DragSource
        DragSource dragSource = DragSource.getDefaultDragSource();

        // Create a DragGestureRecognizer and
        // register as the listener
        dragSource.createDefaultDragGestureRecognizer(
                label, DnDConstants.ACTION_COPY_OR_MOVE,
                this);
    }

    // Implementation of DragGestureListener interface.
    public void dragGestureRecognized(DragGestureEvent dge) {
        if (DnDUtils.isDebugEnabled()) {
            DnDUtils.debugPrintln("Initiating event is " + dge.getTriggerEvent());
            DnDUtils.debugPrintln("Complete event set is:");
            Iterator iter = dge.iterator();
            while (iter.hasNext()) {
                DnDUtils.debugPrintln("\t" + iter.next());
            }
        }
        Transferable transferable = new JLabelTransferable(label);
        dge.startDrag(null, transferable, this);
    }

    // Implementation of DragSourceListener interface
    public void dragEnter(DragSourceDragEvent dsde) {
        DnDUtils.debugPrintln("Drag Source: dragEnter, drop action = "
                + DnDUtils.showActions(dsde.getDropAction()));
    }

    public void dragOver(DragSourceDragEvent dsde) {
        DnDUtils.debugPrintln("Drag Source: dragOver, drop action = "
                + DnDUtils.showActions(dsde.getDropAction()));
    }

    public void dragExit(DragSourceEvent dse) {
        DnDUtils.debugPrintln("Drag Source: dragExit");
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
        DnDUtils.debugPrintln("Drag Source: dropActionChanged, drop action = "
                + DnDUtils.showActions(dsde.getDropAction()));
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        DnDUtils.debugPrintln("Drag Source: drop completed, drop action = "
                + DnDUtils.showActions(dsde.getDropAction())
                + ", success: " + dsde.getDropSuccess());
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Draggable JLabel");
        JLabel label = new JLabel("Drag this text", JLabel.CENTER);
        label.setFont(new Font("Serif", Font.BOLD, 32));
        f.getContentPane().add(label);
        f.pack();
        f.setVisible(true);

        // Attach the drag source
        JLabelDragSource dragSource = new JLabelDragSource(label);
    }

    protected JLabel label;		// The associated JLabel
}

