package gui.touchtone;

import gui.run.DialBean;
import gui.run.SerialPortBean;
import serialPort.Utils;
import utils.StringUtils;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jul 22, 2005
 * <p/>
 * Time: 5:22:32 PM
 */
public class DialUtils {
    public static final String getFilteredDialString(String number, DialBean db) {
        return getDialString(
                filterOutSpacesParensAndDashes(number), db);
    }

    public final static String filterOutSpacesParensAndDashes(String s) {
        StringBuffer sb = new StringBuffer();
        char ca[] = s.toCharArray();
        for (int i = 0; i < ca.length; i++) {
            final char c = ca[i];
            if (c == '-') continue;
            if (Character.isDigit(c)) sb.append(c);
            if (c == ',') sb.append(c);
        }
        return sb.toString();
    }

    public static final String getDialString(String number, DialBean dialBean) {
        number = number.trim();
        String cc = dialBean.getCallingCardNumber();
        if (cc == null) return getATPrefix(dialBean) + number;
        if (!isLongDistance(number)) return getATPrefix(dialBean) + number;
        if (isTollFree(number)) return getATPrefix(dialBean) + '1' + number;
        return getATPrefix(dialBean) +
                filterOutSpacesParensAndDashes(cc + number);
    }

    public static final boolean isTollFree(String number) {
        String s[] = {"800","822","833","844","855","866","877","888"};
        for (int i=0; i < s.length; i++)
          if (number.startsWith(s[i])) return true;
        return false;
    }

    public final static boolean isLongDistance(String number) {
        //noinspection SingleCharacterStartsWith
        if (number.startsWith("1")) return true;
        if (StringUtils.getNumberOfDigits(number) > 7) return true;
        return false;
    }

    public final static String getATPrefix(DialBean dialBean) {
        if (!dialBean.isModemDial()) return "";
        //must be speaker dial  or modem dial
        if (dialBean.isToneDial())
            return "atdt";
        else
            return "atdp";
    }

    public static void doModemDial(String text, final DialBean db) {
        Utils spu = Utils.getSerialPortUtils(SerialPortBean.restore());
        System.out.println("got the serial port utils");

        spu.dial(text, db);
    }
}
