package gui.run;

import java.awt.*;


public class SampleImageApp {

    Image img = null;
    gui.ClosableJFrame cf = new gui.ClosableJFrame("ImageProcessing Frame") {
        public void paint(Graphics g) {
            super.paint(g);
            if (!(img == null))
                g.drawImage(img, 20, 120, null);
        }
    };


    public void openImage() {
        img = getImageFromFile();
        cf.repaint();
    }

    public Image getImageFromFile() {
        return Toolkit.getDefaultToolkit().getImage(futils.Futil.getReadFileName("please select a gif or jpg file"));
    }

    public SampleImageApp() {

        java.awt.Container c = cf.getContentPane();

        javax.swing.JMenuBar mb = new javax.swing.JMenuBar();
        javax.swing.JMenu fileMenu = new javax.swing.JMenu("File");
        fileMenu.setMnemonic('F');
        javax.swing.JMenu hppMenu = new javax.swing.JMenu("Hpp");
        hppMenu.setMnemonic('h');
        fileMenu.add(new RunMenuItem("open") {
            public void run() {
                openImage();
            }
        });
        hppMenu.add(new RunMenuItem("negate") {
            public void run() {
                System.out.println("negate me baby!");
            }
        });
        mb.add(fileMenu);
        mb.add(hppMenu);
        cf.setJMenuBar(mb);
        cf.setSize(200, 200);
        cf.setVisible(true);
    }

    public static void main(String args[]) {
        SampleImageApp om = new SampleImageApp();
    }

}