/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package gui.run;

/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */

import gui.ClosableJFrame;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.*;

public abstract class RunSpinnerSlider extends JPanel implements
                                                      ChangeListener, Runnable {
    private SpinnerNumberModel sm = null;


    public int getValue(){
        return ((Integer) sm.getValue()).intValue();
    }
    public RunSpinnerSlider( SpinnerNumberModel sm
                            ){
        this(sm,RunSlider.HORIZONTAL);

    }
    public   RunSpinnerSlider(final SpinnerNumberModel sm,
                                              int orientation) {
        int max1 = ((Integer) sm.getMaximum()).intValue();
        int min1 = ((Integer) sm.getMinimum()).intValue();
        int initVal = ((Integer) sm.getValue()).intValue();
        this.sm = sm;
        sm.addChangeListener(this);
        final RunSlider runSlider = new RunSlider(orientation,
                min1,
                max1,
                initVal) {
            public void run() {
                sm.setValue(new Integer(getValue()));
            }
        };
        add(runSlider);
        add(new RunSpinner(sm) {
            public void run() {
                int value = ((Integer) getValue()).intValue();
                runSlider.setValue(value);
            }
        });
        setLayout(new FlowLayout());

    }
    public void stateChanged(ChangeEvent event) {
        run();
    }
    public static void main(String args[]) {
        ClosableJFrame cf = new ClosableJFrame();
        final Container contentPane = cf.getContentPane();
        contentPane.setLayout(new FlowLayout());
        final int initialValue = 5;
        final int min = 1;
        final int max = 10;
        final int step = 2;
        final SpinnerNumberModel sm = new SpinnerNumberModel(initialValue,
                min,
                max,
                step);
        final RunSpinnerSlider runSpinnerSlider =
                new RunSpinnerSlider(sm) {
                    public void run() {
                       System.out.println(getValue());
                    }
                };
        contentPane.add(runSpinnerSlider);
        cf.setVisible(true);
        cf.setSize(400, 75);


    }
}
