/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package gui.run;


import gui.ClosableJFrame;
import gui.layouts.DialogLayout;
import serialPort.CommPortUtils;

import javax.swing.*;
import java.awt.*;


public abstract class RunSerialPortPanel
        extends JPanel implements Runnable {

    private SerialPortBean serialPortBean = SerialPortBean.restore();


    public RunSerialPortPanel() {

        init();
    }

    private void init() {
        setLayout(new BorderLayout());
        add(getSerialPanel(), BorderLayout.CENTER);
        add(getButtonPanel(), BorderLayout.SOUTH);

    }

    private JPanel getSerialPanel()  {
        JPanel jp = new JPanel();
        jp.setLayout(new DialogLayout());

        jp.add(new JLabel("Port:"));
        CommPortUtils cpu = CommPortUtils.getCommPortUtils();
        if (cpu == null) return jp;
        RunComboBox cb = new RunComboBox(cpu.getCommPortNames()) {
            public void run() {
                final String name1 = (String)
                        getSelectedItem();
                if (name1 == null) return;
                serialPortBean.setPortName(name1);

            }
        };
        final String serialPortName = serialPortBean.getPortName();
        if (serialPortName != null)
            cb.setSelectedItem(serialPortName);
        jp.add(cb);
        jp.add(new JLabel("baud:"));
        cb = new RunComboBox(cpu.getBaudRates()) {
            public void run() {
                final Integer br = (Integer)
                        getSelectedItem();
                if (br == null) return;
                serialPortBean.setBaudRate(br.intValue());

            }
        };
        cb.setSelectedItem(new Integer(serialPortBean.getBaudRate()));

        jp.add(cb);


        return jp;
    }

    public SerialPortBean getValue() {
        return serialPortBean;
    }


    private JPanel getButtonPanel() {
        JPanel jp = new JPanel();

        jp.setLayout(new FlowLayout());
        jp.add(
                new RunButton("ok") {
                    public void run() {
                        doOk();
                    }
                });
        return jp;
    }

    private void doOk() {
        serialPortBean.save();
        this.run();
    }


    public static void main(String[] args) {
        final ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        c.add(
                new RunSerialPortPanel() {
                    public void run() {
                        System.out.println(getValue());
                        cf.pack();
                    }
                });
        cf.pack();
        cf.setVisible(true);
    }


}