package gui.run;

import gui.ClosableJFrame;
import gui.In;

import javax.swing.*;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import java.awt.*;
import java.util.Vector;


public abstract class RunList extends JList implements
        ListSelectionListener, Runnable {
    public RunList(Vector v) {
        super(v);
        addListSelectionListener(this);
    }

    public DefaultListModel getContents() {
        return (DefaultListModel) getModel();
    }

    public RunList() {
        addListSelectionListener(this);
    }

    public RunList(ListModel dataModel) {
        super(dataModel);
        addListSelectionListener(this);
    }

    public RunList(Object[] listData) {
        super(listData);
        addListSelectionListener(this);
    }

    public void valueChanged(ListSelectionEvent e) {
        // just print once
        if (!e.getValueIsAdjusting())
            run();
    }

    public static void main(String[] args) {
        dyanmicListTest();
    }

    public static void dyanmicListTest() {
        ClosableJFrame cf = new ClosableJFrame("RunList");
        java.awt.Container c = cf.getContentPane();
        c.setLayout(new FlowLayout());
        final DefaultListModel m = new DefaultListModel();
        m.addElement("hi");
        final RunList runList = new RunList(m) {
            public void run() {
                System.out.println(getSelectedValue());
            }
        };
        c.add(runList);
        c.add(new RunButton("add symbol") {
            public void run() {
                m.addElement(In.getString("select symbol"));
            }
        });
        cf.setSize(200, 200);
        cf.setVisible(true);
    }

    public static void testSimpleList() {
        ClosableJFrame cf = new ClosableJFrame("RunList");
        java.awt.Container c = cf.getContentPane();
        String list[] = {"this", "is", "a",
                "test"};
        RunList runList = new RunList(list) {
            public void run() {
                Object o[] = getSelectedValues();
                for (int i = 0; i < o.length; i++)
                    System.out.println(o[i]);
            }
        };
        runList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        c.add(runList);
        c.setLayout(new java.awt.GridLayout(1, 0));
        cf.setSize(200, 200);
        cf.setVisible(true);
    }

    public void add(String name) {
        super.add(name, new JLabel(name));
    }
}