package gui.run;

import gui.ClosableJFrame;

import javax.swing.*;
import javax.swing.border.Border;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

/**
 * DocJava, Inc. http://www.docjava.com Programmer: dlyon Date: Mar 31,
 * 2004 Time: 7:18:20 PM
 */
public class RunLabel extends JLabel implements Runnable {
    RunLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);

        ShortcutUtils.addShortcut(this);
        addMouseListener(new MouseAdapter() {
            public void mousePressed(MouseEvent e) {
                run();
            }
        });

    }

    public RunLabel(String text, int horizontalAlignment) {
        this(text, null, horizontalAlignment);
    }

    public RunLabel(String text) {
        this(text, null, LEADING);
    }

    public RunLabel(Icon image, int horizontalAlignment) {
        this(null, image, horizontalAlignment);
    }

    public RunLabel(Icon image) {
        this(null, image, CENTER);
    }

    public RunLabel() {
        this("", null, LEADING);
    }

    public void run() {

    }


    public void actionPerformed(ActionEvent e) {
        run();
    }

    public static void main(String[] args) {
        ClosableJFrame cj = new ClosableJFrame();
        Container c = cj.getContentPane();
        c.setLayout(new FlowLayout());
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(0, 1));
        JPanel textFieldPanel = new JPanel();
        textFieldPanel.setLayout(new GridLayout(0, 1));
        labelPanel.add(new RunLabel("[Name"));
        RunTextField runTextField = new RunTextField("[Name") {
            public void run() {

            }
        };
        runTextField.setText("");
        textFieldPanel.add(runTextField);
        labelPanel.add(new RunLabel("[House/Street"));
        textFieldPanel.add(new RunTextField("[House") {
            public void run() {

            }
        });
        c.add(textFieldPanel);
        c.add(labelPanel);
        cj.setSize(200, 200);
        cj.setVisible(true);
    }

}
