/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package gui.run;


import graphics.FontUtils;
import gui.ClosableJFrame;
import gui.layouts.DialogLayout;

import javax.swing.*;
import java.awt.*;


public abstract class RunFontPanel
        extends JPanel implements Runnable {

    private FontBean fontBean = FontBean.restore();
    private JLabel sample = new JLabel("Sample");

    public RunFontPanel() {

        init();
    }

    private void init() {
        setLayout(new BorderLayout());
        add(getFontPanel(), BorderLayout.CENTER);
        add(getButtonPanel(), BorderLayout.SOUTH);

    }

    private JPanel getFontPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new DialogLayout());
        jp.add(new JLabel("Font"));
        RunComboBox cb = new RunComboBox(FontUtils.getFontNames()) {
                    public void run() {
                        fontBean.setFontName((String) getSelectedItem());
                        updateSample();
                    }
                };
        cb.setSelectedItem(fontBean.getFontName());
        jp.add(cb);
        jp.add(new JLabel("size"));
        SpinnerNumberModel sm = new SpinnerNumberModel(fontBean.getFontSize(),
                2,
                174,
                1);
        jp.add(new RunSpinnerSlider(sm) {
            public void run() {
                fontBean.setFontSize(getValue());
                updateSample();
            }
        });
        jp.add(new JLabel("style"));
        jp.add(getFontStylePanel());
        jp.add(new JLabel("sample"));
        jp.add(sample);
        return jp;
    }

    private void updateSample() {
        sample.setFont(getValue());

    }

    public Font getValue() {
        return new Font(fontBean.getFontName(),
                fontBean.getFontStyle(),
                fontBean.getFontSize());
    }

    private JPanel getFontStylePanel() {
        JPanel jp = new JPanel();

        jp.setLayout(new FlowLayout());
        jp.add(new RunButton("plain") {
            public void run() {
                fontBean.setFontStyle(Font.PLAIN);
                updateSample();
            }
        });
        jp.add(new RunButton("italic") {
            public void run() {
                fontBean.setFontStyle(Font.ITALIC);
                updateSample();
            }
        });
        jp.add(new RunButton("bold") {
            public void run() {
                fontBean.setFontStyle(Font.BOLD);
                updateSample();
            }
        });
        jp.add(new RunButton("bold/italic") {
            public void run() {
                fontBean.setFontStyle(Font.BOLD | Font.ITALIC);
                updateSample();

            }
        });
        return jp;
    }

    private JPanel getButtonPanel() {
        JPanel jp = new JPanel();

        jp.setLayout(new FlowLayout());
        jp.add(new RunButton("ok") {
            public void run() {
                fontBean.save();
                RunFontPanel.this.run();
            }
        });
        return jp;
    }




    public static void main(String[] args) {
        final ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        c.add(new RunFontPanel() {
            public void run() {
                System.out.println(getValue());
                cf.pack();
            }
        });
        cf.pack();
        cf.setVisible(true);
    }


}