/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package gui.run;


import gui.ClosableJFrame;

import javax.swing.*;
import java.awt.*;


public abstract class RunFindPanel
        extends JPanel implements Runnable {

    private FindBean findBean = FindBean.restore();

    public RunFindPanel() {

        init();
    }

    private void init() {
        setLayout(new BorderLayout());
        final RunTextField runTextField = new RunTextField("", 20) {
                            public void run() {
                                findBean.setFindString(getText());
                                doFind();
                            }
                        };
        add(runTextField, BorderLayout.NORTH);
        add(getCheckboxPanel(), BorderLayout.CENTER);
        add(getButtonPanel(), BorderLayout.SOUTH);

    }

    private JPanel getCheckboxPanel() {
        JPanel jp = new JPanel();
        jp.setBorder(BorderFactory.createEtchedBorder());
        jp.setLayout(new GridLayout(2, 0));
        jp.add(
                new RunCheckBox("In Name", findBean.isInName()) {
                    public void run() {
                        findBean.setInName(isSelected());
                    }
                });
        jp.add(
                new RunCheckBox("In Address", findBean.isInAddress()) {

                    public void run() {
                        findBean.setInAddress(isSelected());
                    }
                });
        jp.add(
                new RunCheckBox("In Info.", findBean.isInInfo()) {
                    public void run() {
                        findBean.setInInfo(isSelected());
                    }
                });
        jp.add(
                new RunCheckBox("In Phone", findBean.isInPhone()) {
                    public void run() {
                        findBean.setInPhone(isSelected());
                    }
                });
        return jp;
    }

    private JPanel getButtonPanel() {
        JPanel jp = new JPanel();

        jp.setLayout(new FlowLayout());
       
        jp.add(
                new RunButton("[Find") {
                    public void run() {
                        doFind();
                    }
                });
        jp.add(
                new RunButton("e[xit") {
                    public void run() {
                        findBean.save();
                        doExit();
                    }
                });
        return jp;
    }

    public abstract void doExit();

    private void doFind() {
        findBean.save();
        run();
    }


    public FindBean getFindBean() {
        return findBean;
    }


    public static void main(String[] args) {
        final ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        c.add(
                new RunFindPanel() {
                    public void run() {
                        System.out.println(getFindBean());
                    }

                    public void doExit() {
                        cf.setVisible(false);
                    }
                });
        cf.setSize(200, 200);
        cf.setVisible(true);
    }


}