/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package gui.run;

import gui.ClosableJFrame;
import j2d.color.Yiq;
import j2d.color.Yuv;

import javax.swing.*;
import javax.vecmath.Matrix3d;
import java.awt.*;


public abstract class RunColor3dPanel extends
        JPanel implements
        Runnable {
    Matrix3d m3d = new Matrix3d();

    public Matrix3d getValue() {
        return m3d;
    }

    private void updateSpinnerModel(SpinnerNumberModel[][] snm,Matrix3d m3d) {
        for (int i = 0; i < snm.length; i++) {
            for (int j = 0; j < snm[0].length; j++) {
                double element = m3d.getElement(i, j);
                System.out.println(element);
                snm[i][j].setValue(new Integer((int) (100 * element)));
            }
        }
    }

    public RunColor3dPanel() {
        setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        RunMatrix3dPanel rm3dp = new RunMatrix3dPanel() {
            public void run() {
                RunColor3dPanel.this.m3d = getValue();
                RunColor3dPanel.this.run();
            }
        };
        final SpinnerNumberModel snm[][] = rm3dp.getModel();
        tabbedPane.addTab("3dMatrix", rm3dp);
        tabbedPane.addTab("color space", new ButtonControlPanel() {
            public void run() {
                Matrix3d value = getValue();
                RunColor3dPanel.this.m3d = value;
                updateSpinnerModel(snm,value);
                RunColor3dPanel.this.run();
            }
        });

        add(BorderLayout.CENTER, tabbedPane);

    }


    private abstract class ButtonControlPanel extends JPanel implements Runnable {
        private Matrix3d m3d = new Matrix3d();
        private ButtonGroup bg = new ButtonGroup();

        public Matrix3d getValue() {
            return m3d;
        }

        ButtonControlPanel() {
            setLayout(new FlowLayout());
            addRadioButton(new RunRadio("rgb2yuv") {
                public void run() {
                    m3d = Yuv.getRgb2yuvMat().getMatrix3d();
                    ButtonControlPanel.this.run();
                }
            });
            addRadioButton(new RunRadio("rgb2iyq") {
                public void run() {
                    m3d = Yiq.getRgb2yiqMat().getMatrix3d();
                    ButtonControlPanel.this.run();
                }
            });
        }


        public void addRadioButton(RunRadio rr) {
            add(rr);
            bg.add(rr);
        }

    }

    public static void main(String[] args) {

        showColorPanel();

    }

    public static RunColor3dPanel showColorPanel() {
        ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        final Matrix3dView view = new Matrix3dView();
        RunColor3dPanel runColor3dPanel = new RunColor3dPanel() {
                    public void run() {
                        Matrix3d value = getValue();
                        //System.out.println(value);
                        view.updateView(value);
                    }
                };
        c.add(runColor3dPanel);

        c.add(view);
        c.setLayout(new FlowLayout());
        cf.setSize(400, 400);
        cf.setVisible(true);
        return runColor3dPanel;
    }


}
