package gui.run;

import gui.ClosableJFrame;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 * Just like the RunTextFieldOld except that each
 * char causes an invocation of the run method
 */
public abstract class RunCharField extends
        JTextField
        implements ActionListener,
        KeyListener,
        FocusListener,
        Runnable {
    private String originalText = null;
    private boolean isNotRunWithKeyPressed = true;

    /**
     * Invoked when a component gains the keyboard focus.
     */
    public void focusGained(FocusEvent e) {
    }

    ;

    /**
     * Invoked when a component loses the keyboard focus.
     */
    public void focusLost(FocusEvent e) {
        run();
    }

    ;

    public String getOriginalText() {
        return originalText;
    }

    public void keyTyped(KeyEvent e) {

    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (isNotRunWithKeyPressed)
            return;
        run();
    }

    public RunCharField(String text, boolean editable) {
        this(text);
        initEditable(editable);
    }

    public RunCharField(String text) {
        super(text);
        originalText = text;
        initListeners();
    }

    private void initListeners() {
        addActionListener(this);
        ShortcutUtils.addShortcut(this);
        addKeyListener(this);
        addFocusListener(this);
    }

    /**
     * remove the keyListener and the focus listener.
     */
    public void removeKeyAndFocusListeners() {
        removeKeyListener(this);
        removeFocusListener(this);
    }


    public RunCharField() {
        this("");
    }

    public RunCharField(int columns, boolean editable, boolean isRunWithKeyPressed) {
        this(columns);
        this.isNotRunWithKeyPressed = !isRunWithKeyPressed;
        initEditable(editable);
    }

    public RunCharField(boolean isRunWithKeyPressed) {
        this("");
        this.isNotRunWithKeyPressed = isRunWithKeyPressed;
    }

    public RunCharField(int columns, boolean editable) {
        this(columns);
        initEditable(editable);
    }

    private void initEditable(boolean editable) {
        setEditable(editable);
        setFocusable(editable);
    }

    public RunCharField(int columns) {
        super(columns);
        initListeners();
    }

    public RunCharField(String text,
                        int columns) {
        super(text, columns);
        initListeners();
    }

    public RunCharField(javax.swing.text.Document doc,
                        String text,
                        int columns) {
        super(doc, text, columns);
        initListeners();
    }

    public void actionPerformed(ActionEvent e) {
        run();
    }

    public static void main(String[] args) {
        ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        c.setLayout(new FlowLayout());

        RunCharField comp = new RunCharField(20, true, false) {
            public void run() {
                System.out.println(getText());
            }
        };
        comp.removeKeyAndFocusListeners();
        c.add(comp);
        cf.setSize(200, 200);
        cf.setVisible(true);
    }

}