/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package gui.run;

import gui.ClosableJFrame;
import gui.In;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;


public class MouseCheckBoxPanel extends JPanel {
    private RunCheckBox rcb[][];

    public MouseCheckBoxPanel(int w) {
        rcb = new RunCheckBox[w][w];
        for (int x = 0; x < w; x++)
            for (int y = 0; y < w; y++) {
                final RunCheckBox cb = new RunCheckBox(){
                    public void run(){
                        //System.out.println(isSelected());
                    }
                };
                add(cb);
                rcb[x][y] = cb;

                cb.addMouseListener(getCheckBoxListener(cb));
            }
        setLayout(new GridLayout(w, 0,0,0));
        super.setToolTipText("alt turns on, control turns off");
    }
    public void setBackground(Color c){
        if (rcb == null) return;
        for (int i=0; i < rcb.length; i++)
            for (int j=0; j < rcb[0].length;j++)
                rcb[i][j].setBackground(c);
        super.setBackground(c);
    }
    public JCheckBox [][] getValue(){
        return rcb;
    }

    private MouseListener getCheckBoxListener(final JCheckBox cb) {
        return new MouseListener(){
                            public void mouseClicked(MouseEvent event){}

                            public void mousePressed(MouseEvent event) {
                            }

                            public void mouseReleased(MouseEvent event) {
                            }

                            public void mouseEntered(MouseEvent event) {
                                if (event.isAltDown())
                                    cb.setSelected(true);
                                else if (event.isControlDown())
                                    cb.setSelected(false);
                            }

                            public void mouseExited(MouseEvent event) {


                            }
                        };
    }


    public static void main(String[] args) {
        testRunCheckBox();
    }

    public static void testRunCheckBox() {
        ClosableJFrame cf = new ClosableJFrame("RunCheckBox");
        Container c = cf.getContentPane();
        int size = In.getInt("input an odd number",3,33);
        final MouseCheckBoxPanel mcbp = new MouseCheckBoxPanel(size);
        c.add(mcbp);
        c.add(
                new RunButton("ok") {
                    public void run() {
                        printState(mcbp.rcb);
                    }
                });
        c.setLayout(new FlowLayout());

        cf.pack();
        cf.setVisible(true);

    }
    public static char getBinary(boolean b){
        if (b == true) return '1';
        return '0';
    }
    private static  void printState(RunCheckBox rcb1[][]) {
       for (int i=0; i < rcb1.length; i++) {
           for (int j = 0; j < rcb1[0].length; j++) {
                 System.out.print(getBinary(rcb1[i][j].isSelected()));

           }
           System.out.println();
       }
    }
}