/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package gui.run;

import utils.CompactJava;

import java.io.*;
import java.util.prefs.Preferences;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 3, 2005
 * <p/>
 * Time: 4:40:58 PM
 */
public class LabelBean implements Serializable {
    private int rightMargin = 14;
    private int leftMargin = 14;
    private int topMargin = 25;
    private int bottomMargin = 25;
    private int numberOfLabels = 30;
    private int numberOfLabelsPerColumn = 10;
    private int horizontalGutter = (int) (0.15625 * 25.4);
    private int verticalGutter = 0;
    private static String key = "labelBean";

    public LabelBean() {

    }

    /**
     * saves the properties to the Preferences of the userRoot
     */
    public void save() {
        try {
            Preferences p = Preferences.userRoot();
            ByteArrayOutputStream baos = new
                    ByteArrayOutputStream();
            ObjectOutputStream oos = new
                    ObjectOutputStream(baos);
            oos.writeObject(this);
            baos.close();
            p.putByteArray(key, baos.toByteArray());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return CompactJava.toXml(this);
    }

    /**
     * restores the properties from the preference in the user root.
     */
    public static LabelBean restore() {
        try {
            Preferences p = Preferences.userRoot();
            byte b [] = p.getByteArray(key, null);
            if (b == null)
                return new LabelBean();
            ByteArrayInputStream bais = new
                    ByteArrayInputStream(b);
            ObjectInputStream ois = new
                    ObjectInputStream(bais);
            Object o = ois.readObject();
            bais.close();
            return (LabelBean) o;
        } catch (IOException e) {
            //e.printStackTrace();
        } catch (ClassNotFoundException e) {
            // e.printStackTrace();
        }
        return new LabelBean();
    }

    public int getRightMargin() {
        return rightMargin;
    }

    public void setRightMargin(int rightMargin) {
        this.rightMargin = rightMargin;
    }

    public int getLeftMargin() {
        return leftMargin;
    }

    public void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
    }

    public int getTopMargin() {
        return topMargin;
    }

    public void setTopMargin(int topMargin) {
        this.topMargin = topMargin;
    }

    public int getBottomMargin() {
        return bottomMargin;
    }

    public void setBottomMargin(int bottomMargin) {
        this.bottomMargin = bottomMargin;
    }

    public int getNumberOfLabels() {
        return numberOfLabels;
    }

    public void setNumberOfLabels(int numberOfLabels) {
        this.numberOfLabels = numberOfLabels;
    }

    public int getNumberOfLabelsPerColumn() {
        return numberOfLabelsPerColumn;
    }

    public void setNumberOfLabelsPerColumn(int numberOfLabelsPerColumn) {
        this.numberOfLabelsPerColumn = numberOfLabelsPerColumn;
    }

    public int getHorizontalGutter() {
        return horizontalGutter;
    }

    public void setHorizontalGutter(int horizontalGutter) {
        this.horizontalGutter = horizontalGutter;
    }

    public int getVerticalGutter() {
        return verticalGutter;
    }

    public void setVerticalGutter(int verticalGutter) {
        this.verticalGutter = verticalGutter;
    }
}
