/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package gui.run;

import utils.CompactJava;
import utils.PreferencesUtils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.prefs.Preferences;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 3, 2005
 * <p/>
 * Time: 4:40:58 PM
 */
public class DialBean implements Serializable {

    private String callingCardNumber = "";


    private static String key = "DialBean";
    private boolean toneDial = true;
    private boolean modemDial = true;
    private int speed = 95; //in ms


    public DialBean() {

    }

    public String toString() {
        return CompactJava.toXml(this);
    }

    /**
     * saves the properties to the Preferences of the userRoot
     */
    public void save() {
        PreferencesUtils pu = new PreferencesUtils(key);
        pu.save(this);
    }

    public static DialBean restore() {
        PreferencesUtils pu = new PreferencesUtils(key);
        Object o = pu.restore();

        if (o == null)
            return new DialBean();
        if (o instanceof DialBean) 
            return (DialBean) o;
        return new DialBean();
    }


    public boolean isToneDial() {
        return toneDial;
    }

    public void setToneDial(boolean toneDial) {
        this.toneDial = toneDial;
        save();
    }

    public String getCallingCardNumber() {
        return callingCardNumber;
    }

    public void setCallingCardNumber(String callingCardNumber) {
        this.callingCardNumber = callingCardNumber;
        save();
    }

    public boolean isModemDial() {
        return modemDial;
    }

    public void setModemDial(boolean modemDial) {
        this.modemDial = modemDial;
        save();
    }

    public int getSpeed() {
        return speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
        save();
    }
}
