package gui.mouse;


public class MouseComponentMover extends MouseController {
    java.awt.Component c;

    public MouseComponentMover(java.awt.Component _c) {
        c = _c;
        c.setCursor(java.awt.Cursor.getPredefinedCursor(
                java.awt.Cursor.HAND_CURSOR));
        c.addMouseMotionListener(this);
        c.addMouseListener(this);
    }

    public void dragShift(java.awt.Point p1, java.awt.Point p2) {
        javax.swing.SwingUtilities.convertPointToScreen(p2, c);
        c.setSize(p2.x - c.getBounds().x, p2.y - c.getBounds().y);
        c.setCursor(java.awt.Cursor.getPredefinedCursor(
                java.awt.Cursor.SE_RESIZE_CURSOR));
    }

    public void dragged(java.awt.Point p1, java.awt.Point p2) {
        c.setCursor(java.awt.Cursor.getPredefinedCursor(
                java.awt.Cursor.HAND_CURSOR));
        javax.swing.SwingUtilities.convertPointToScreen(p2, c);
        c.setLocation(p2.x, p2.y);
    }

    public void clicked(java.awt.Point p) {
    }

    public void shiftClicked(java.awt.Point p) {
    }

    public void pressed(java.awt.Point p) {
    }

    public void doubleClicked(java.awt.Point p) {
    }

    public void released(java.awt.Point p) {
        c.setCursor(java.awt.Cursor.getPredefinedCursor(
                java.awt.Cursor.HAND_CURSOR));
    }
}