package gui.html;

public class HtmlSynthesizer {
    private String imageHome = "c:\\lyon\\www\\";

    public void print(double x) {
        System.out.println(x);
    }

    public void print(String s) {
        System.out.println(s);
    }

    public String getHtml(String s) {
        return "<html>\n" + s + "\n</html>";
    }

    public String getHomePage() {
        return "<a href=\"http://lyon.fairfield.edu\">home</a>\n";
    }

    public String getHomePage(int n) {
        String s = getHomePage();
        for (int i = 0; i < n; i++)
            s = s + getHomePage();
        return s;
    }

    public static String getListItem(String s) {
        return "<li>" + s + "</li>\n";
    }
    public static String getListItems(String s[]) {
        StringBuffer sb = new StringBuffer();
        for (int i=0; i < s.length; i++)
            sb.append(getListItem(s[i]));
        return sb.toString();
    }

    public static String getBreak() {
        return "\n<br>\n ";
    }

    public static String getH1(String s) {
        return "<h1>\n" + s + "\n</h1>";
    }

    public static String getSubmit() {
        return
                "<input type=submit"
                + " value=submit>\n";
    }

    public static String getOption(String s) {
        return "\t<option value=" + s + " >" + s + '\n';
    }

    public static String getSelect(String name, String options[]) {
        String s = "";
        ;
        for (int i = 0; i < options.length; i++)
            s = s + getOption(options[i]);
        return "<select name=" + name + ">" + s + "</select>";
    }

    public static String getSelect(String name, int n) {
        String sn[] = new String[n];
        for (int i=0; i < n; i++)
            sn[i]=""+i;
        return getSelect(name, sn);
    }

    public static String getH2(String s) {
        return "<h2>\n" + s + "\n</h2>";
    }

    public static String getH3(String s) {
        return "<h3>\n" + s + "\n</h3>";
    }

    public static String getH4(String s) {
        return "<h4>\n" + s + "\n</h4>";
    }

    public static String getH5(String s) {
        return "<h5>\n" + s + "\n</h5>";
    }

    public static String getH6(String s) {
        return "<h6>\n" + s + "\n</h6>";
    }

    public static String getP(String s) {
        return "<p>\n" + s + "\n</p>";
    }

    public static String getBody(String s) {
        return "<body>\n" + s + "\n</body>";
    }

    public static String getHead(String s) {
        return "<Head>\n" + s + "\n</Head>\n";
    }

    public static String getTitle(String s) {
        return "<title>\n" + s + "\n</title>\n";
    }

    public static String getCaption(String s) {
        return
                "<caption>"
                + s
                + "</caption>";
    }

    public static String getTr(String s) {
        return "<tr>" + s + "</tr>\n";
    }
    //<td width="91" height="39">c11</td>

    public static String getTd(int w, int h, String s) {
        return "\n\t<td width=\""
                + w
                + "\" height=\"" + h + "\">"
                + s +
                "</td>\n";
    }

    public static String getTd(String s) {
        return "\n\t<td>"
                + s +
                "</td>\n";
    }

    public static String getRow(int r, int nc) {
        String s = "";
        for (int c = 1; c <= nc; c++)
            s = s + getTd(r + "," + c + " ");
        return s;

    }

    public static String getSheet(String a[][]) {
        String s = "";
        for (int i = 0; i < a.length; i++) {
            s = "<tr>" + s;
            for (int j = 0; j < a[i].length; j++) {
                s = s + getTd(a[i][j]);
            }
            s = s + "</tr><p>\n";
        }
        return s;
    }

    public String getSheet(String a[]) {
        String s = "";
        for (int i = 0; i < a.length; i++) {
            s = "<tr>" + s;
            s = s + getTd(a[i]);
            s = s + "</tr><p>\n";
        }
        return s;
    }

    public String getTable(String s) {
        return "\n<table border=1>\n" + s + "\n</table>\n";
    }

    public String getInput(
            String type,
            String name,
            String value,
            int size) {
        return
                "\n<input type=" + quote(type)
                + "name=" + quote(name)
                + " value=" + quote(value)
                + "size=" + size
                + ">\n";
    }

    public String getImage(String imageName) {
        return "<img src="
                + quote(imageName)
                + "alt=" + imageName
                + ">";

    }

    public String getInput(
            String type,
            String name,
            String value) {
        return
                "\n<input type=" + type + ' '
                + "name=" + name
                + " value=" + value
                + " >";
    }
    // <input type="radio" name="B1_Rating" value="Excellent">

    public String getRadio(String name, String value) {
        return
                getInput("radio", name, value) + value;
    }

    //<INPUT TYPE="text" NAME="UID" VALUE="" SIZE=30>
    public String getTextField(String name, String value, int size) {
        return
                getInput("text", name, value, 30);
    }

    public String getRadioButtons(String name, int b) {
        String s = "";
        for (int i = 1; i <= b; i++)
            s = s + getRadio(name, i + "");
        return "<p>" + s + "";
    }

    public String getPassField(String name, String value, int size) {
        return
                getInput("password", name, value, 30);
    }

    public String getTextField(String name, String value) {
        return
                getTextField(name, value, 30);
    }

    public String getPassField(String name, String value) {
        return
                getPassField(name, value, 30);
    }

    public String getPassField(String name) {
        return
                getPassField(name, "", 30);
    }

    public String getTextField(String name) {
        return
                getTextField(name, "", 30);
    }

    //<FORM action="" method="POST">
    public String getForm(String action, String method, String s) {
        return "\n<form action=" + quote(action)
                + "method=" + quote(method) + ">\n"
                + s + ' '
                + "\n </form >\n";
    }

    public String quote(String s) {
        return '\"' + s + "\" ";
    }

    public String getTable(int nr, int nc) {
        String s = "<TABLE BORDER=1>";
        for (int r = 1; r <= nr; r++) {
            s = s +
                    getTr(getRow(r, nc));
            // assume number of columns is the
            // same for each row
        }
        return s + "</table>";
    }

    public String testForm1() {
        return
                getHtml(
                        getHead(getTitle("testForm")) +
                getBody(
                        getForm("", "GET",
                                getP(getTextField("name")) +
                getPassField("password") +
                getRadioButtons("q1", 5)

                        )
                )
                );
    }

    public String[] getSelects(String name, int n) {
        String s[] = new String[n];
        s[0] = name;
        for (int i = 1; i < n; i++)
            s[i] = getSelect(name,n);
        return s;
    }
    public String testForm2() {
        String a[][] = {
            {"a1", "a2"},
            {"b1", "b2"}
        };

        return getHtml(getHead("test of html Synthesizer")
        + getBody(getH1("heading 1")
                +getH2(new java.util.Date()+"")
                +getH3("heading 3")
                +getSheet(a)
                +getPassField("password", "",30)
                +getSubmit()
        ));
    }
    public String testGetListItems() {
       String list[] = {"Student Name", "Analytic Skills",
             "Communication Skills",
             "creative problem solving"};
        return getHtml(getTitle("listItems")+getListItems(list));
    }
    public String testForm() {
        int n = 10;
        String a [][] = {
            {"Student Name", "Analytic Skills",
             "Communication Skills",
             "creative problem solving"},
            getSelects("doe", n),
            getSelects("shmoe", n),
            getSelects("wanker", n),
            getSelects("spanker", n),
            getSelects("peabody", n),
        };
        return
                getHtml(
                        getHead(
                                getTitle(
                                        "my title!")) +
                getBody(
                        getHomePage(10) +
                getForm(
                        "http://localhost/examples/servlet/HelloWorldExample",
                        "GET",
                        getTable(
                                getCaption("My Caption")
                + getSheet(a))
                + getSubmit()
                + getImage(
                        "http://showAndRegister.docjava.com:8086/consulti/docjava.jpe")

                )
                )
                );
    }

    public static void main(String args[]) {
        //System.out.println(getSampleForm());
        HtmlViewer hv = new HtmlViewer();
        HtmlSynthesizer hs = new HtmlSynthesizer();
        hv.setString(
                getSampleForm()+
                hs.testForm());
                //hs.testGetListItems());
        hv.setVisible(true);
    }

    private static String getSampleForm() {
        HtmlSynthesizer hs = new HtmlSynthesizer();
        return
                hs.getHtml(
                        hs.getForm("", "GET",
                                hs.getTextField("name")) +
                hs.getTable(9, 20));
    }
}
