package gui.dialogs.checkbox;/*
 * Copyright (c) 2005 Your Corporation. All Rights Reserved.
 */


import utils.CompactJava;

import java.io.*;
import java.util.prefs.Preferences;

/**Robert Distinti
 The image matrix bean -- modified from DocJava PreferencesBean
 */
public class MatrixBean implements Serializable{
    private static final String key = "ece430.gui.dialogs.checkbox.MatrixBean";
    private String fileName = null;
    private int matrixSize=5;          // matrix size of one indictaes that it is has not been loaded
    private byte[][] data=new byte[5][5];
    /**
     * saves the properties to the Preferences of the userRoot
     */
    public void save() {
        try {
            Preferences p = Preferences.userRoot();
            ByteArrayOutputStream baos = new
                    ByteArrayOutputStream();
            ObjectOutputStream oos = new
                    ObjectOutputStream(baos);
            oos.writeObject(this);
            baos.close();
            p.putByteArray(key, baos.toByteArray());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return CompactJava.toXml(this);
    }

    /**
     * restores the properties from the preference in the user root.
     */
    public static MatrixBean restore() {
        try {
            Preferences p = Preferences.userRoot();
            byte b [] = p.getByteArray(key, null);
            if (b == null)
                return new MatrixBean();
            ByteArrayInputStream bais = new
                    ByteArrayInputStream(b);
            ObjectInputStream ois = new
                    ObjectInputStream(bais);
            Object o = ois.readObject();
            bais.close();
            return (MatrixBean) o;
        } catch (IOException e) {
            //e.printStackTrace();
        } catch (ClassNotFoundException e) {
            // e.printStackTrace();
        }
        return new MatrixBean();
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public byte[][] getData() {
        return data;
    }

    public void setData(byte[][] data) {
        if(data.length==matrixSize){
            this.data = data;
        }else if(this.data==null){
            setMatrixSize(data.length);
            if(data.length==matrixSize){
                this.data = data;
            }
        }
    }

    public int getMatrixSize() {
        return matrixSize;
    }

    public void setMatrixSize(int matrixSize) {
        int x,y,i,j,ofst,c;
        // first make sure it is odd
        matrixSize=matrixSize|1;
        byte newData[][]=new byte[matrixSize][matrixSize];
        // first see if the size has changed
        if (this.matrixSize == matrixSize) return;
        // see if we are expanding or contracting
        if ((this.matrixSize > matrixSize)){
            //contracting -- just take center elements
            ofst=(this.matrixSize-matrixSize)/2;
            c=matrixSize;
            for(i=0;i<c; i++){
                for(j=0;j<c;j++){
                    newData[i][j]=data[i+ofst][j+ofst];
                }
            }
        }else{
            // expanding -- keep it centered
            ofst=(matrixSize-this.matrixSize)/2;
            c=this.matrixSize;
            for(i=0;i<c; i++){
                for(j=0;j<c;j++){
                    newData[i+ofst][j+ofst]=data[i][j];
                }
            }
        }
        this.matrixSize = matrixSize;
        data=newData;
    }



}

