package gui.dialogs.checkbox;/*
 * Copyright (c) 2005 Your Corporation. All Rights Reserved.
 */


import gui.ClosableJFrame;
import gui.In;
import gui.layouts.VerticalLayout;
import gui.run.RunButton;

import javax.swing.*;
import java.awt.*;

/**
 * Created by Robert Distinti.
 * User: default
 * Date: Sep 19, 2005
 * Time: 1:53:41 AM
 */
public class Matrix extends ClosableJFrame {
    private MatrixBean o = MatrixBean.restore();
    private CheckBoxPanel mcbp;

    // refresh is performed whenever size has changed
    private void refresh() {
        ClosableJFrame cf = this;
        Container c = cf.getContentPane();
        c.remove(mcbp);
        mcbp = new CheckBoxPanel(o);
        c.add(mcbp, BorderLayout.CENTER);
        cf.pack();
        cf.setVisible(true);
    }

    public Matrix() {
        setTitle("Select Image matrix");
        ClosableJFrame cf = this;
        Container c = cf.getContentPane();
        c.setLayout(new BorderLayout());

        mcbp = new CheckBoxPanel(o);
        c.add(mcbp, BorderLayout.CENTER);

        JPanel jp = new JPanel(new VerticalLayout());
        c.add(jp, BorderLayout.EAST);

        jp.add(
                new RunButton("ok") {
                    public void run() {
                        mcbp.saveValues(); // save it to bean
                        o.save(); // save bean to preferences

                    }
                });
        jp.add(
                new RunButton("cancel") {
                    public void run() {
                        o = MatrixBean.restore();
                        refresh();
                    }
                });
        jp.add(
                new RunButton("resize") {
                    public void run() {
                        int size = In.getInt("input an odd number", 3, 33);
                        mcbp.saveValues(); // save it to bean
                        o.setMatrixSize(size);
                        refresh();
                    }
                });
        refresh();
    }

    public static void main(String[] args) {
        Matrix mything = new Matrix();
    }


}

