package gui.dialogs.checkbox;/*
 * Copyright (c) 2005 Your Corporation. All Rights Reserved.
 */


import gui.run.RunCheckBox;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class CheckBoxPanel extends JPanel {
    private RunCheckBox rcb[][];
    private MatrixBean myBean;

    public CheckBoxPanel(MatrixBean data) {
        int w=data.getMatrixSize();
        myBean=data;
        rcb = new RunCheckBox[w][w];
        for (int x = 0; x < w; x++)
            for (int y = 0; y < w; y++) {
                RunCheckBox cb = new RunCheckBox(){
                    public void run(){
                        //System.out.println(isSelected());
                    }
                };
                add(cb);
                rcb[x][y] = cb;
                cb.addMouseListener(getCheckBoxListener(cb));
            }
        setLayout(new GridLayout(w, 0,0,0));
        super.setToolTipText("alt turns on, control turns off");
        loadValues();
    }

    public void setBackground(Color c){
        if (rcb == null) return;
        for (int i=0; i < rcb.length; i++)
            for (int j=0; j < rcb[0].length;j++)
                rcb[i][j].setBackground(c);
        super.setBackground(c);
    }

    private MouseListener getCheckBoxListener(final JCheckBox cb) {
        return new MouseListener(){
            public void mouseClicked(MouseEvent event){}

            public void mousePressed(MouseEvent event) {
            }

            public void mouseReleased(MouseEvent event) {
            }

            public void mouseEntered(MouseEvent event) {
                if (event.isAltDown())
                    cb.setSelected(true);
                else if (event.isControlDown())
                    cb.setSelected(false);
            }

            public void mouseExited(MouseEvent event) {
            }
        };
    }

    public static char getBinary(boolean b){
        if (b) return '1';
        return '0';
    }
    private static  void printState(RunCheckBox rcb1[][]) {
        for (int i=0; i < rcb1.length; i++) {
            for (int j = 0; j < rcb1[0].length; j++) {
                System.out.print(getBinary(rcb1[i][j].isSelected()));

            }
            System.out.println();
        }
    }

    private void loadValues() {
        byte data[][]=myBean.getData();
        // use min
        int x,y;
        x=data.length;
        y=data[0].length;
        //noinspection OverlyComplexBooleanExpression
        if(isInRange(x, y))return;
        if(x>rcb.length)x=rcb.length;
        if(y>rcb[0].length)x=rcb[0].length;
        for (int i=0; i < x; i++) {
            for (int j = 0; j < y; j++) {
                if(data[i][j]>0){
                    rcb[i][j].setSelected(true);
                }else{
                    rcb[i][j].setSelected(false);
                }
            }
        }
    }

    public void saveValues() {
        byte data[][]=myBean.getData();
        // use min
        int x,y;
        x=data.length;
        y=data[0].length;
        if(isInRange(x, y))return;
        if(x>rcb.length)x=rcb.length;
        if(y>rcb[0].length)x=rcb[0].length;
        for (int i=0; i < x; i++) {
            for (int j = 0; j < y; j++) {
                if(rcb[i][j].isSelected()){
                    data[i][j]=1;
                }else{
                    data[i][j]=0;
                }
            }
        }
    }

    private boolean isInRange(int x, int y) {
        final boolean b;
        b = x == 0 || y == 0;
        return b ||rcb.length==0||rcb[0].length==0;
    }
}

