// Decompiled by Jad v1.5.8e2. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://kpdus.tripod.com/jad.html
// Decompiler options: packfields(3) packimports(7) deadcode fieldsfirst splitstr(64) nonlb lnc radix(10) lradix(10) 

package gui.dialogs;

import javax.media.jai.widget.ImageCanvas;
import javax.media.jai.widget.ViewportListener;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.event.*;
import java.awt.image.RenderedImage;
import java.util.Vector;

// Referenced classes of package javax.media.jai.widget:
//            ImageCanvas, ViewportListener

/**
 */

public class ScrollingAwtImagePanel extends ScrollPane
    implements AdjustmentListener, ComponentListener, MouseListener, MouseMotionListener {

    protected ImageCanvas ic;
    protected RenderedImage im;
    protected int panelWidth, panelHeight;
    protected Vector viewportListeners;
    protected Point moveSource;
    protected boolean beingDragged;
    protected Cursor defaultCursor;

    public ScrollingAwtImagePanel(RenderedImage renderedimage, int i, int j) {
        viewportListeners = new Vector();
        beingDragged = false;
        defaultCursor = null;
        im = renderedimage;
        panelWidth = i;
        panelHeight = j;
        ic = new ImageCanvas(renderedimage);
        getHAdjustable().addAdjustmentListener(this);
        getVAdjustable().addAdjustmentListener(this);
        super.setSize(i, j);
        addComponentListener(this);
        add("Center", ic);
    }

    public void addViewportListener(ViewportListener viewportlistener) {
        viewportListeners.addElement(viewportlistener);
        viewportlistener.setViewport(getXOrigin(), getYOrigin(), panelWidth, panelHeight);
    }

    public void removeViewportListener(ViewportListener viewportlistener) {
        viewportListeners.removeElement(viewportlistener);
    }

    private void notifyViewportListeners(int i, int j, int k, int l) {
        int j1 = viewportListeners.size();
        for(int i1 = 0; i1 < j1; i1++) {
            ViewportListener viewportlistener = (ViewportListener)viewportListeners.elementAt(i1);
            viewportlistener.setViewport(i, j, k, l);
        }

    }

    public ImageCanvas getImageCanvas() {
        return ic;
    }

    public int getXOrigin() {
        return ic.getXOrigin();
    }

    public int getYOrigin() {
        return ic.getYOrigin();
    }

    public void setOrigin(int i, int j) {
        ic.setOrigin(i, j);
        notifyViewportListeners(i, j, panelWidth, panelHeight);
    }

    public synchronized void setCenter(int i, int j) {
        int k = 0;
        int l = 0;
        int i1 = im.getWidth();
        int j1 = im.getHeight();
        int k1 = getViewportSize().width;
        int l1 = getViewportSize().height;
        int i2 = getHAdjustable().getBlockIncrement();
        int j2 = getVAdjustable().getBlockIncrement();
        if(i < k1 - i1 / 2)
            k = 0;
        else
        if(i > i1 / 2)
            k = i1 - k1;
        else
            k = i + (i1 - k1 - i2) / 2;
        if(j < l1 - j1 / 2)
            l = 0;
        else
        if(j > j1 / 2)
            l = j1 - l1;
        else
            l = j + (j1 - l1 - j2) / 2;
        getHAdjustable().setValue(k);
        getVAdjustable().setValue(l);
        notifyViewportListeners(getXOrigin(), getYOrigin(), panelWidth, panelHeight);
    }

    public void set(RenderedImage renderedimage) {
        im = renderedimage;
        ic.set(renderedimage);
    }

    public int getXCenter() {
        return getXOrigin() + panelWidth / 2;
    }

    public int getYCenter() {
        return getYOrigin() + panelHeight / 2;
    }

    public Dimension getPreferredSize() {
        return new Dimension(panelWidth, panelHeight);
    }

    public void setBounds(int i, int j, int k, int l) {
        super.setBounds(i, j, k, l);
        int i1 = getViewportSize().width;
        int j1 = getViewportSize().height;
        int k1 = im.getWidth();
        int l1 = im.getHeight();
        if(i1 >= k1 && j1 >= l1)
            ic.setBounds(i, j, k, l);
        else
            ic.setBounds(i, j, i1, j1);
        panelWidth = k;
        panelHeight = l;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentevent) {
    }

    public void componentResized(ComponentEvent componentevent) {
        notifyViewportListeners(getXOrigin(), getYOrigin(), panelWidth, panelHeight);
    }

    public void componentHidden(ComponentEvent componentevent) {
    }

    public void componentMoved(ComponentEvent componentevent) {
    }

    public void componentShown(ComponentEvent componentevent) {
    }

    private synchronized void startDrag(Point point) {
        setCursor(Cursor.getPredefinedCursor(13));
        beingDragged = true;
        moveSource = point;
    }

    protected synchronized void updateDrag(Point point) {
        if(beingDragged) {
            int i = moveSource.x - point.x;
            int j = moveSource.y - point.y;
            moveSource = point;
            int k = getHAdjustable().getValue() + i;
            int l = getVAdjustable().getValue() + j;
            setOrigin(k, l);
        }
    }

    private synchronized void endDrag() {
        setCursor(Cursor.getPredefinedCursor(0));
        beingDragged = false;
    }

    public void mousePressed(MouseEvent mouseevent) {
        startDrag(mouseevent.getPoint());
    }

    public void mouseDragged(MouseEvent mouseevent) {
        updateDrag(mouseevent.getPoint());
    }

    public void mouseReleased(MouseEvent mouseevent) {
        endDrag();
    }

    public void mouseExited(MouseEvent mouseevent) {
        endDrag();
    }

    public void mouseClicked(MouseEvent mouseevent) {
    }

    public void mouseMoved(MouseEvent mouseevent) {
    }

    public void mouseEntered(MouseEvent mouseevent) {
    }
}
