/*
 * Copyright (c) 2005 DocJava. All Rights Reserved.
 */
package gui.date;

/**
 * Created by IntelliJ IDEA.
 * User: lyon
 * Date: Oct 8, 2005
 * Time: 4:39:43 PM
 *
 */

import gui.ClosableJFrame;
import gui.run.RunButton;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.*;
import java.util.Calendar;
import java.util.Date;

public abstract class RunDatePanel extends JPanel implements Runnable {
    private Calendar calendar = Calendar.getInstance();
    private SpinnerListModel dateModel = addDates("Date ");
    private SpinnerListModel monthModel = addMonths(dateModel, "Month: ");
    private SpinnerModel yearModel = addYear(monthModel, "Year: ");

    public RunDatePanel() {
        super(new SpringLayout());
        //Lay out the panel.
        SpringUtilities.makeCompactGrid(this,
                3, 2, //rows, cols
                10, 10,        //initX, initY
                6, 10);       //xPad, yPad
        mediator();
    }

    public void mediator() {
        class ChangeAdapter implements ChangeListener {
            public void stateChanged(ChangeEvent e) {
                run();
            }
        }
        ChangeAdapter ca = new ChangeAdapter();
        dateModel.addChangeListener(ca);
        monthModel.addChangeListener(ca);
        yearModel.addChangeListener(ca);
    }


    private SpinnerModel addYear(SpinnerListModel monthModel, String label) {

        //Add second label-spinner pair.
        int currentYear = calendar.get(Calendar.YEAR);
        final SpinnerModel yearModel =
                new SpinnerNumberModel(currentYear,
                        currentYear - 100, //min
                        currentYear + 100, //max
                        1);                //step

        //Hook this model up to the month model.
        ((CyclingSpinnerListModel) monthModel).setLinkedModel(yearModel);

        JSpinner spinner = addLabeledSpinner(this, label, yearModel);
        //Make the year be formatted without a thousands separator.
        spinner.setEditor(new JSpinner.NumberEditor(spinner, "#"));
        return yearModel;
    }


    private SpinnerListModel addDates(String label) {
        JFormattedTextField ftf;
        //Add the first label-spinner pair.
        String[] dateStrings = getDateStrings();
        final SpinnerListModel dateModel = new gui.date.CyclingSpinnerListModel(dateStrings);

        JSpinner spinner = addLabeledSpinner(this,
                label,
                dateModel);
        //Tweak the spinner's formatted text field.
        ftf = getTextField(spinner);
        if (ftf != null) {
            ftf.setColumns(8); //specify more width than we need
            ftf.setHorizontalAlignment(JTextField.RIGHT);
        }
        return dateModel;
    }


    private SpinnerListModel addMonths(SpinnerListModel dateModel, String label) {
        JFormattedTextField ftf;
        //Add the first label-spinner pair.
        String[] monthStrings = getMonthStrings(); //get month names
        SpinnerListModel monthModel;

        monthModel = new CyclingSpinnerListModel(monthStrings);

        //when date rolls over, we go to next month...
        ((CyclingSpinnerListModel) dateModel).setLinkedModel(monthModel);
        JSpinner spinner = addLabeledSpinner(this,
                label,
                monthModel);
        //Tweak the spinner's formatted text field.
        ftf = getTextField(spinner);
        if (ftf != null) {
            ftf.setColumns(8); //specify more width than we need
            ftf.setHorizontalAlignment(JTextField.RIGHT);
        }
        return monthModel;
    }

    /**
     * Return the formatted text field used by the editor, or
     * null if the editor doesn't descend from JSpinner.DefaultEditor.
     */
    public JFormattedTextField getTextField(JSpinner spinner) {
        JComponent editor = spinner.getEditor();
        if (editor instanceof JSpinner.DefaultEditor) {
            return ((JSpinner.DefaultEditor) editor).getTextField();
        } else {
            System.err.println("Unexpected editor type: "
                    + spinner.getEditor().getClass()
                    + " isn't a descendant of DefaultEditor");
            return null;
        }
    }

    public Date getDate() {
        String value = (String) dateModel.getValue();
        calendar.set(Calendar.DATE, Integer.valueOf(value).intValue());
        calendar.set(Calendar.MONTH, getMonthNumber());
        Integer val = (Integer) yearModel.getValue();
        calendar.set(Calendar.YEAR, val.intValue());
        return calendar.getTime();
    }

    private int getMonthNumber() {
        String value1 = (String) monthModel.getValue();
        String months[] = getMonthStrings();
        int i = 0;
        for (; i < months.length; i++)
            if (months[i].equals(value1)) break;
        return i;
    }


    private static String[] getDateStrings() {
        String dates[] = new String[31];
        for (int i = 0; i < dates.length; i++)
            dates[i] = i + 1 + "";
        return dates;
    }

    /**
     * DateFormatSymbols returns an extra, empty value at the
     * end of the array of months.  Remove it.
     */
    private static String[] getMonthStrings() {
        String[] months = new java.text.DateFormatSymbols().getMonths();
        int lastIndex = months.length - 1;

        if (months[lastIndex] == null
                || months[lastIndex].length() <= 0) { //last item empty
            String[] monthStrings = new String[lastIndex];
            System.arraycopy(months, 0,
                    monthStrings, 0, lastIndex);
            return monthStrings;
        } else { //last item not empty
            return months;
        }
    }

    private static JSpinner addLabeledSpinner(Container c,
                                              String label,
                                              SpinnerModel model) {
        JLabel l = new JLabel(label);
        c.add(l);
        JSpinner spinner = new JSpinner(model);
        l.setLabelFor(spinner);
        c.add(spinner);
        return spinner;
    }

    public static void main(String[] args) {
        final ClosableJFrame cf = new ClosableJFrame("RunDatePanel");
        Container c = cf.getContentPane();
        c.setLayout(new BorderLayout());
        //Create and set up the content pane.
        final RunDatePanel dp = new RunDatePanel(){
            public void run(){
                //System.out.println(getDate());
            }
        };
        JPanel bp = new JPanel();
        bp.setLayout(new FlowLayout());

        bp.add(new RunButton("OK") {
            public void run() {
                System.out.println(dp.getDate());
                cf.setVisible(false);
            }
        });
        bp.add(new RunButton("cancel") {
            public void run() {
                System.exit(0);
            }
        });
        c.add(dp, BorderLayout.CENTER);
        c.add(bp, BorderLayout.SOUTH);

        //Display the window.
        cf.pack();
        cf.setVisible(true);
    }
}

