package gui.date;

import gui.In;
import gui.run.RunButton;

import javax.swing.*;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.awt.*;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jan 8, 2005
 * <p/>
 * Time: 1:10:47 PM
 */
public class DateUtils {
    public static final String SIMPLE_DATE_PATTERN = "M/d/yy";
    public static final SimpleDateFormat SIMPLE_DATE_FORMAT =
            new SimpleDateFormat(SIMPLE_DATE_PATTERN);

    public static void main(String[] args) {
        System.out.println("date:"+getDate());
    }

    /**
     * prompt the user for a date
     * @return  a date instance
     */
     public static Date getDate(){
        final JDialog jd = new JDialog();
        jd.setModal(true);
        Container c = jd.getContentPane();
        c.setLayout(new BorderLayout());
        //Create and set up the content pane.
        final RunDatePanel dp = new RunDatePanel(){
            public void run(){
                
            }
        };
        JPanel bp = new JPanel();
        bp.setLayout(new FlowLayout());

        bp.add(new RunButton("OK") {
            public void run() {
                System.out.println(dp.getDate());
                jd.setVisible(false);
            }
        });
        bp.add(new RunButton("cancel") {
            public void run() {
                System.exit(0);
            }
        });
        c.add(dp, BorderLayout.CENTER);
        c.add(bp, BorderLayout.SOUTH);

        //Display the window.
        jd.pack();
        jd.setVisible(true);
        return dp.getDate();
     }
    /**
     * Input a simple date in M/d/yy format.
     * Performs error correction with a modal dialog.
     * returns todays date if there is an error.
     * @param s
     * @return
     */
    public static Date getSimpleDate(String s) {
        DateFormat df = SIMPLE_DATE_FORMAT;
        try {
            return df.parse(s);
        } catch (ParseException e) {
            return new Date();
        }

    }
    public static Date getDate(Date d){
        DateFormat df = SIMPLE_DATE_FORMAT;
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(d);
        String s = df.format(gc.getTime());
        s = In.getString("enter date:"+s);
        try {
            return df.parse(s);
        }catch(ParseException e){
            In.alert("improper format, try again");
            return getDate(d);
        }

    }
}
