package gui.componentEditor;

import gui.run.*;

import javax.swing.*;
import java.awt.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;


public class ComponentEditor {

    static JDesktopPane desktop = new JDesktopPane();
    static final JFrame f = new JFrame("Component Editor");

    public static void main(String[] args) {

        final Container c = f.getContentPane();
        c.setBackground(Color.white);
        desktop.setLayout(null);
        desktop.setBackground(Color.white);
        c.add(desktop);


        JMenuBar mb = new JMenuBar();

        JMenu menuFile = new JMenu("File");
        menuFile.add(new RunMenuItem("Exit") {
            public void run() {
                System.exit(0);
            }
        });

        JMenu menuComponent = new JMenu("Add Component");

        menuComponent.add(new RunMenuItem("add Button") {
            public void run() {
                desktop.add(new RunButton("Button") {
                    public void run() {
                        //do the button thing
                    }
                });
            }
        });

        menuComponent.add(new RunMenuItem("add Slider") {
            public void run() {
                desktop.add(new RunSlider(0, 0, 100, 50) {
                    public void run() {
                        //do the slider thing
                    }
                });
            }
        });

        menuComponent.add(new RunMenuItem("add TextField") {
            public void run() {
                desktop.add(new RunTextField("TextField") {
                    public void run() {
                        //do the textfield thing
                    }
                });
            }
        });

        menuComponent.add(new RunMenuItem("add List") {
            public void run() {
                String[] data = {"This", "is", "a", "List"};
                desktop.add(new RunList(data) {
                    public void run() {
                        //do the list thing;
                    }
                });
            }
        });

        menuComponent.add(new RunMenuItem("add PasswordField") {
            public void run() {
                desktop.add(new RunPasswordField("Password Field") {
                    public void run() {
                        //do the passwordfield thing
                    }
                });
            }
        });

        menuComponent.add(new RunMenuItem("add CheckBox") {
            public void run() {
                desktop.add(new RunCheckBox("CheckBox") {
                    public void run() {
                        //do the checkbox thing
                    }
                });
            }
        });

        mb.add(menuFile);
        mb.add(menuComponent);

        f.setJMenuBar(mb);

        f.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.setSize(600, 600);
        f.setVisible(true);

    }

}