package gui;

import classUtils.dumper.ClassFile;
import futils.Futil;
import gui.run.RunButton;
import gui.run.RunColorChooser;

import javax.swing.*;
import java.awt.*;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;

public final class In {

    private In() {
    } // prevent others from instancing


    public static void testAtomicInput() {
        String name = getString("please enter your name");
        int age = getInt("please enter your age[0..150]",
                0,
                150);
        message("name=" + name);
        message("age=" + age);
        float f = getFloat("enter a number between 0.0 and 1.0 inclusive:",
                0,
                1);
        In.message("you entered:" + f);
    }

    /**
     * Prompt the user for a string. Use a modal
     * dialog.
     *
     * @param o prompt for the user
     * @return a string
     */
    public static String getString(Object o) {
        return JOptionPane.showInputDialog(o);
    }

    /**
     * Prompt the user for a password. Do not echo
     * the input. Use a modal dialog box.
     *
     * @return A string (not the typical array of
     *         char).
     */
    public static String getPassword(String message) {
        JTextField passwordField = new JPasswordField(20);
        Object[] ob = {passwordField};
        int result =
                JOptionPane.showConfirmDialog(null,
                        ob,
                        message,
                        JOptionPane.OK_CANCEL_OPTION);
        if (result == JOptionPane.OK_OPTION)
            return passwordField.getText();
        else
            return "";
    }

    /**
     * Use a modal dialog to display an exception,
     * with an error icon.
     *
     * @param e the exception
     */
    public static boolean message(Exception e) {
        Object[] options = {"ok"};
        e.printStackTrace();
        int foo = JOptionPane.showOptionDialog(null,
                e,
                "Exception",
                JOptionPane.DEFAULT_OPTION,
                JOptionPane.ERROR_MESSAGE,
                null,
                options,
                options[0]);
        return foo == 0;
    }


    public static void testGetColor() {
        In.message("you selected:" +
                getColor());
    }

    /**
     * Present the user with a modal Dialog
     * prompting for a color.
     *
     * @return color upon user selection.
     */
    public static Color getColor() {
        return RunColorChooser.getColorAtomic();
    }

    /**
     * Present the user with a modal dialog
     * containing a message
     */
    public static boolean message(Object messageString) {
        Object[] options = {"ok"};
        int foo = JOptionPane.showOptionDialog(null,
                messageString,
                "Message",
                JOptionPane.DEFAULT_OPTION,
                JOptionPane.PLAIN_MESSAGE,
                null,
                options,
                options[0]);
        return foo == 0;
    }

    /**
     * Present the user with a modal dialog containing a message
     */
    public static boolean alert(String messageString) {
        Object[] options = {"ok"};
        int foo = JOptionPane.showOptionDialog(null,
                messageString,
                "Message",
                JOptionPane.DEFAULT_OPTION,
                JOptionPane.ERROR_MESSAGE,
                null,
                options,
                options[0]);
        return foo == 0;
    }

    public static void multiPromptTest() {
        String s[] = {"tom", "dick", "harry"};
        System.out.println(multiPrompt(s,
                "select an option",
                "mutliTestDialog"));
    }

    /**
     * Present the user with a modal dialog that
     *
     * @param options an array of options to
     *                select from
     * @param message the message to the user
     * @param title   the title of the dialog
     * @return the selected option
     */
    public static Object multiPrompt(Object options[],
                                     String message,
                                     String title) {
        if (options == null) return null;
        //Object showInputDialog(Component parentComponent,
        //Object message, String title, int messageType, Icon icon,
        //Object[] selectionValues, Object initialSelectionValue)
        return JOptionPane.showInputDialog(null,
                message,
                title,
                JOptionPane.QUESTION_MESSAGE,
                null,
                options,
                options[0]);
    }

    /**
     * Present the user with a modal dialog,
     * prompting the user for a yes or no
     * response.
     *
     * @param messageString The prompt
     * @return true is user selects yes.
     */
    public static boolean getBoolean(String messageString) {
        Object[] options = {"yes", "no"};
        int foo = JOptionPane.showOptionDialog(null,
                messageString,
                "Warning",
                JOptionPane.DEFAULT_OPTION,
                JOptionPane.WARNING_MESSAGE,
                null,
                options,
                options[0]);
        return foo == 0;
    }

    /**
     * Prompt the user for a floating point
     * number
     *
     * @param o prompt for the float string
     * @return a parsed primative float
     */
    public static float getFloat(Object o) {
        float f;
        try {
            f =
                    Float.parseFloat(JOptionPane.showInputDialog(o));
        } catch (NumberFormatException e) {
            f =
                    getFloat(e +
                            "I need a float, try again!");
        }
        return f;
    }

    /**
     * Prompt the user for an float that is <= the
     * lo value and >= the high value. perform
     * error checking on the input.
     *
     * @param lo inclusive lower bound on input
     * @param hi inclusive upper bound on input.
     * @return a float between lo and hi,
     *         inclusive.
     */
    public static float getFloat(String prompt,
                                 float lo,
                                 float hi) {
        float f = getFloat(prompt);
        if (f <= hi && f >= lo) return f;
        In.message(" your last ans:" +
                f +
                " was out of range");
        return getFloat(prompt, lo, hi);
    }

    public static void rangeTest() {
        int anInt = getInt("enter a number from 1 to 10",
                1,
                10);
        System.out.println("got a value:" +
                anInt);
    }

    /**
     * Prompt the user for an int that is <= the
     * lo value and >= the high value. perform
     * error checking on the input.
     *
     * @param lo inclusive lower bound on input
     * @param hi inclusive upper bound on input.
     * @return an int between lo and hi,
     *         inclusive.
     */
    public static int getInt(String prompt,
                             int lo,
                             int hi) {
        int anInt = getInt(prompt);
        if (anInt <= hi && anInt >= lo) return anInt;
        return getInt(prompt +
                " your last ans:" +
                anInt +
                " was out of range", lo, hi);
    }


    /**
     * Prompt the user with a modal dialog for an
     * int. Perform error checking to make sure
     * that an int is returned.
     *
     * @return an int
     */
    public static int getInt(Object o) {
        int i;
        try {
            i =
                    Integer.parseInt(JOptionPane.showInputDialog(o));
        } catch (NumberFormatException e) {
            i =
                    getInt(e +
                            "I need an int, try again!");
        }
        return i;
    }

    public static void testGetString() {
        System.out.println("Hello " +
                getString("Please Enter your class:"));
        System.out.println("There are "
                +
                getFloat("Please Enter the number of students:")
                +
                "Students in your class");
        //System.out.println( "your grade= "+getDouble("Please Enter your grade:"));
    }

    public static Class getClassFromUser() {
        String cn = In.getString("enter a fully qualified class name");
        if (cn == null) return null;
        try {
            return Class.forName(cn);
        } catch (ClassNotFoundException e) {
            message(e);
            message("did you select a class file in your path?");
            if (In.getBoolean("would you like to try again?"))
                return getClassFromUser();
            System.exit(0);
            return null;
        }
    }

    public static Class getClassFileUser() {
        try {
            File f = Futil.getReadFile("select a class file to be made remote");
            ClassFile cf = ClassFile.getClassFile(f);
            String cn = cf.getClassName();
            return Class.forName(cn);
        } catch (ClassNotFoundException e) {
            message(e);
            message("did you select a class file in your path?");
            if (In.getBoolean("would you like to try again?"))
                return getClassFileUser();
            System.exit(0);
            return null;
        }
    }

    public static Rectangle getRectangle(String s) {
        final JDialog jd = new JDialog();
        jd.setTitle(s);
        Container c = jd.getContentPane();
        c.setLayout(new FlowLayout());
        jd.setSize(200, 200);
        jd.setModal(true);
        jd.setResizable(true);
        c.add(new RunButton(s) {
            public void run() {
                jd.setVisible(false);

            }
        });
        jd.setVisible(true);
        return new Rectangle(jd.getLocation(),
                jd.getSize());
    }

    public static void main(String[] args) {
        System.out.println(In.getMonth());
    }

    public static String [] getMonths() {
        return new String[]{"Jan", "Feb", "March", "April"};
    }

    private static String getMonth() {
        String[] months = getMonths();
        return (String) multiPrompt(months,
                "select a state",
                "State Dialog");
    }
    //todo: test and finish this.
    public static Date getDate() {
        return new Date();
    }

    /**
     * return a two-letter state abbreviation for the USA.
     *
     * @return two letter string
     */
    public static String getState() {
        String[] states = getStates();
        return (String) multiPrompt(states,
                "select a state",
                "State Dialog");
    }

    public static int getStateNum(String state) {
        String [] statelist = getStates();

        for (int i = 0; i < statelist.length; i++) {
            if (state.equals(statelist[i]))
                return i;
        }

        return -1;
    }


    public static String[] getStates() {
        return new String[]{"AL",
                "AK",
                "AR",
                "AZ",
                "CA",
                "CO",
                "CT",
                "DE",
                "DC",
                "FL",
                "GA",
                "GU",
                "HI",
                "IN",
                "IL",
                "ID",
                "IA",
                "KS",
                "KY",
                "LA",
                "ME",
                "MD",
                "MA",
                "MI",
                "MN",
                "MS",
                "MO",
                "MT",
                "NE",
                "NV",
                "NH",
                "NJ",
                "NM",
                "NY",
                "NC",
                "ND",
                "OH",
                "OK",
                "OR",
                "PA",
                "PR",
                "RI",
                "SC",
                "SD",
                "TN",
                "TX",
                "TT",
                "UT",
                "VA",
                "VI",
                "VT",
                "WA",
                "WV",
                "WI",
                "WY"};
    }

    public static URL getUrl(String prompt) {
        String s = getString(prompt);
        if (s == null) return null;
        URL u;
        try {
            u = new URL(s);

        } catch (MalformedURLException e) {
            return getUrl(s + " invalid, try again");
        }
        return u;
    }

    public static double getDouble(Object o) {
        String s = getString(o);
        try {
            Double d = Double.valueOf(s);
            return d.doubleValue();
        } catch (NumberFormatException e) {
            return getDouble(s + " is not a double!" + o);
        }
    }

    public static String[] getStates2() {


        return new String[]{"AL",
                "AK",
                "AZ",
                "AR",
                "CA",
                "CO",
                "CT",
                "DE",
                "DC",
                "FL",
                "GA",
                "GU",
                "HI",
                "ID",
                "IL",
                "IN",
                "IA",
                "KS",
                "KY",
                "LA",
                "ME",
                "MD",
                "MA",
                "MI",
                "MN",
                "MS",
                "MO",
                "MT",
                "NE",
                "NV",
                "NH",
                "NJ",
                "NM",
                "NY",
                "NC",
                "ND",
                "OH",
                "OK",
                "OR",
                "PA",
                "PR",
                "RI",
                "SC",
                "SD",
                "TN",
                "TX",
                "TT",
                "UT",
                "VT",
                "VI",
                "VA",
                "WA",
                "WV",
                "WI",
                "WY"
                 };
    }

    public static String[] getLawyerTypes() {
        return new String[]{"Any Type of Lawyer","Admiralty", "Aviation", "Bankruptcy",
                                 "Civil Rights", "Consumer", "Criminal", "Education", "ElderLaw",
                                 "Employment", "Entertainment", "Family", "General Practice", "Health",
                                 "Immigration", "Insurance", "Intellectual Property", "Legal Malpractice",
                                 "Medical Malpractice", "Military Law", "Personal Injury","Products Liability",
                                 "Real State", "Securities", "Social Security", "Taxation", "Toxic torts",
                                 "Trusts and Estates", "Wills and Probate"


        };
         }

    public static String[] getLawyerTypesRefNum() {

        return new String[]{"111", "723", "727", "729", "731", "841","738", "740",
                                      "741", "760", "863", "748", "877", "752", "753", "755",
                                      "756", "761", "764", "766", "769", "770", "772", "773",
                                      "933", "774", "776", "778", "779"
        };
    }

    public static String getLawyerType() {
        String[] lawyerTypes = getLawyerTypes();
        return (String) In.multiPrompt(lawyerTypes ,
                "select a Type of Lawyer",
                "Lawyer Type Dialog");
    }

    /**
     *
     * return a two-letter state abbreviation for the USA.
     * @return two letter string
     */
    public static String getState2() {
        String[] states = getStates2();
        return (String)In.multiPrompt(states,
                "select a state",
                "State Dialog");
    }
}

