package graphics.graph;


import java.awt.*;

import futils.Futil;
import net.date.MainServer;

/**
 *	Start up the application.
 */
public class Main {
    public static void main(String args[]) {
        ControlPanel g;
        new ControlPanel();
        g = setupGraph();
        setupFrame(g);
        System.out.println("g.start");
    }

    private static void setupFrame(ControlPanel cp) {
        ClosableFrame f = new ClosableFrame();
        f.setSize(400, 400);
        f.setLayout(new BorderLayout());
        f.add(cp.getControlPanel(),
                BorderLayout.SOUTH);
        f.add(cp.getImagePanel(),
                BorderLayout.CENTER);
        f.setVisible(true);
        cp.start();
    }


    public static String getName(Class c){
        return c.getName();
    }
    private static ControlPanel setupGraph() {
        ControlPanel g = new ControlPanel();
        String s = net.date.AtomicClock.class.getClass().getName();
        g.addEdge(s, getName(net.compute.AutoServer.class));
        g.addEdge(s, getName(gui.html.Browser.class));
        g.addEdge(s, getName(gui.html.AddressForm.class));
        g.addEdge(s, getName(gui.html.LoginForm.class));
        g.addEdge(s, getName(gui.html.HtmlSynthesizer.class));
        g.addEdge(s, getName(gui.html.HtmlUtil.class));


        s = getName(Futil.class);
        g.addEdge(s, MainServer.class);
        g.addEdge(s, futils.SimpleWriter.class);




        g.start();
        return g;
    }
}