package graphics.graph;

import gui.run.RunButton;
import gui.run.RunCheckBox;

import java.awt.*;

public class ControlPanel {
    private GraphImagePanel imagePanel
            = GraphImagePanel.getImagePanel();
    private GraphManager graphManager
            = GraphManager.getGraphManager();


    private Nodes nodes
            = GraphFactory.getNodes();
    private EdgesBean edgesBean
            = EdgesBean.getEdgesBean();

    public Nodes getNodes() {
        return nodes;
    }

    public void println(Object o) {
        System.out.println(o);
    }

    public void println(Object o[]) {
        for (int i = 0; i < o.length; i++)
            System.out.println(o[i]);
    }

    public void synthesizeRMI() {
        println("Synthesizing RMI");
        println("getting bridge endpoints:");
        Node fixedNodes[] =
                nodes.getFixedNodes();
        println(fixedNodes);
    }

    public void addEdge(String nodeName1, String nodeName2) {
        edgesBean.addEdge(nodeName1, nodeName2);
    }

    public GraphManager getGraphManager() {
        return graphManager;
    }

    public GraphImagePanel getImagePanel() {
        return imagePanel;
    }

    public Panel getControlPanel() {
        Panel p = new Panel();
        p.setLayout(new FlowLayout());
        addComponentsToPanel(p);
        return p;
    }

    private void addComponentsToPanel(Panel p) {
        p.add(new RunButton("Scramble") {
            public void run() {
                scrambleNodes();
            }
        });
        p.add(new RunButton("Synthesize RMI") {
            public void run() {
                synthesizeRMI();
            }
        });
        p.add(new RunButton("Shake") {
            public void run() {
                shakeNodes();
            }
        });

        p.add(new RunCheckBox("Stress") {
            public void run() {
                StressBean sb = StressBean.getStressBean();
                sb.setStress(isSelected());
            }
        });

        p.add(new RunCheckBox("Random") {
            public void run() {
                RandomBean rb = RandomBean.getRandomBean();
                rb.setRandom(isSelected());
                graphManager.getRelaxThreadMgr().setRandom(isSelected());
            }
        });
    }

    public void start() {
        graphManager.start();
    }

    private void shakeNodes() {
        for (int i = 0;
             i < nodes.getNumberOfNodes();
             i++) {
            Node n = nodes.getNode(i);
            if (n.isFixed()) return;
            n.setX(n.getX()
                    + (180 * Math.random() - 90));
            n.setY(n.getY()
                    + (180 * Math.random() - 90));
        }
    }

    private void scrambleNodes() {
        Dimension d = imagePanel.getSize();
        for (int i = 0; i < nodes.getNumberOfNodes(); i++) {
            Node n = nodes.getNode(i);
            if (!n.isFixed()) {
                n.setX(10 + (d.width - 20) * Math.random());
                n.setY(10 + (d.height - 20) * Math.random());
            }
        }
    }


    public void addEdge(String s, Class nodeName2) {
        addEdge(s,getName(nodeName2));
    }

    private String getName(Class nodeName2) {
        return nodeName2.getName();
    }
}
