package futils;

import javax.swing.*;
import java.awt.*;
import java.io.*;

public final class WriterUtil {
    /**
     * Don't let anyone instantiate this class.
     */
    private WriterUtil() {
    }


    // Some versions of windows will
// create a .* suffix on a file name
// The following code will strip it:
    public static String FilterFileNameBug(
            String fname) {
        if (fname.endsWith(".*.*")) {
            fname =
            fname.substring(0,
                            fname.length() - 4);
        }
        return fname;
    }

    public static String getWriteDirectoryName(
            String prompt) {
        FileDialog dialog = new FileDialog(
                new Frame(),
                prompt,
                FileDialog.SAVE);
        dialog.setVisible(true);
        String fs = dialog.getDirectory();
        dialog.dispose();
        return FilterFileNameBug(fs);
    }


    public static File getDirFileAWT(
            String prompt) {
        FileDialog fd =
                new FileDialog(new Frame(),
                               prompt);
        fd.setVisible(true);
        String dirName = fd.getDirectory();
        fd.dispose();
        return new File(dirName);
    }

    public static File JGetDirFile(String prompt) {
        JFileChooser jfc = new JFileChooser();
        jfc.showOpenDialog(new JFrame(prompt));
        File f = jfc.getSelectedFile();
        return f.getParentFile();
    }

    public static File getDirFile(String prompt) {
        if (Futil.isSwing())
            return JGetDirFile(prompt);
        return getDirFileAWT(prompt);
    }


    public static void writeFilteredHrefFile(
            String inputFileName,
            String outputFileName) {
        System.out.println("Filtering:\t" +
                           inputFileName +
                           "\t>\t" +
                           outputFileName);
        try {
            FileReader fr = new FileReader(
                    inputFileName);
            StreamTokenizer st =
                    new StreamTokenizer(fr);


            FileOutputStream fos = new FileOutputStream(
                    outputFileName);
            PrintWriter output = new PrintWriter(
                    fos);
            int i;
            int next = 0;
            st.resetSyntax();
            st.wordChars(0, 255);
            st.quoteChar('"');
            while ((next = st.nextToken()) !=
                   StreamTokenizer.TT_EOF) {
                switch (next) {
                    case '"':
                        output.print('"');
                        for (i = 0; i <
                                    st.sval.length(); i++)
                            if (st.sval.charAt(i) ==
                                ' ')
                                output.print(
                                        "%20");
                            else
                                output.print(
                                        st.sval.charAt(
                                                i));
                        output.print('"');
                        break;
                    case StreamTokenizer.TT_WORD:
                        output.print(
                                st.sval + " ");
                        break;
                    case StreamTokenizer.TT_NUMBER:
                        output.print(
                                st.nval + " ");
                        break;
                    case StreamTokenizer.TT_EOL:
                        output.println();
                        break;
                } // end switch
            } // end while
            fr.close();
            fos.close();
        } // end try
        catch (Exception exe) {
            System.out.println(
                    "writeFilteredHrefFile:er!");
        }
    }

    public static final char CARRAGE_RETURN = 13;
    public static final char LINE_FEED = 10;
    public static final String NEW_LINE = ""
                                          +
                                          CARRAGE_RETURN +
                                          LINE_FEED;

    public static void main(String[] args) {
        testWriteString();

    }


    public void lowerFileNames(File thePath) {
        String[] fileNames = thePath.list();
        String pathstr = thePath.getPath();
        for (int i = 0;
             fileNames != null &&
             i < fileNames.length; i++) {
            String aFileName = fileNames[i];
            String newFileName = aFileName.toLowerCase();
            File theFile = new File(pathstr,
                                    aFileName);
            if (theFile.isFile()) {
                //rename theFile to lower case
                System.out.print(
                        i + ":" + aFileName);
                theFile.renameTo(new File(
                        pathstr,
                        newFileName));
                System.out.println(
                        "\t==>\t" + newFileName);
            } else {
                //case theFile is Dir, in the Dir, repeat same procedure
                System.out.println(
                        "Dir:" + aFileName);
                lowerFileNames(
                        new File(
                                pathstr +
                                aFileName));
            }
        }
        return;
    }//lowerFileNames

    /**
     * Convert a file to a FileWriter
     *
     * @param f The input File
     * @return A FileWriter obtained from the
     *         file
     */
    public static FileWriter getFileWriter(
            File f) {
        if (f==null) return null;
        try {
            return new FileWriter(f);
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void testGetCSVString() {
        int ia[] = {
            1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 11, 12, 13, 14
        };
        System.out.println(getCSVString(ia));
    }

    public static String getCSVString(int ia[]) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ia.length; i++) {
            sb.append("" + ia[i] + NEW_LINE);
        }
        return sb.toString();
    }

    public static void testWriteString() {
        writeString(
                "This is a test of write string" +
                NEW_LINE
                + " this is more stuff" +
                NEW_LINE
                +
                "I hope these newlines come out ok");
        System.out.println(
                "testWriteString ends");
    }

    /**
     * Write a string out to a file. Prompts the
     * user for a file name ouputs the string to
     * the file, then closes the file.
     *
     * @param s The string to write out.
     */
    public static void writeString(String s) {
        FileWriter fw = getFileWriter(
                "enter output file");

        writeString(fw, s);
    }
    public static void writeString(File f, String s){
        if (f==null) return ;
        writeString(getFileWriter(f),s);
    }
    public static void writeString(FileWriter fw, String s) {
        try {
            fw.write(s);
            fw.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * Write a string out to a file. Prompts the
     * user for a file name ouputs the string to
     * the file, then closes the file.
     *
     * @param s The string to write out.
     */
    public static void writeString(String s[]) {
        FileWriter fw = getFileWriter(
                "enter output file");
        try {
            for (int i = 0; i < s.length; i++)
                fw.write(s[i]);

            fw.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeString2(File f,
                                    String s) {
        try {
            FileOutputStream fos = new FileOutputStream(
                    f);
            FileWriter fw = new FileWriter(f);
            fw.write(s);
            fw.close();
            fos.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * prompt the user for a file and return a
     * writer.
     *
     * @param prompt the string prompt displayed
     *               to the user.
     * @return A FileWriter obtained from a use
     *         selection
     */
    public static FileWriter getFileWriter(
            String prompt) {
        return getFileWriter(
                Futil.getWriteFile(prompt));
    }

    /**
     * "@param prompt
     */
    public static BufferedWriter
            getBufferedWriter(String prompt) {
        File f = Futil.getWriteFileSwing(prompt);
        if (f==null) return null;
        return getBufferedWriter(f);
    }

    /**
     * "@param f
     */
    public static BufferedWriter
            getBufferedWriter(File f) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(
                    new FileWriter(f));
        } catch (IOException e) {
        }
        return bw;
    }

    /**
     * "@param bw
     */
    public static void close(BufferedWriter bw) {
        try {
            bw.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getWriteDirectoryName() {
        FileDialog dialog = new FileDialog(
                new Frame(),
                "Enter file name",
                FileDialog.SAVE);
        dialog.setVisible(true);
        String fs = dialog.getDirectory();
        System.out.println("Opening file: " + fs);
        dialog.dispose();
        return Futil.FilterFileNameBug(fs);
    }

    public static void close(FileWriter fw) {
        try {
            fw.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static File[] getFiles(String prompt) {
        File readFile = Futil.getReadFile(prompt);
        System.out.println("readFile=" +
                           readFile);
        File parent = readFile.getParentFile();
        return
                parent.listFiles(
                        new FileFilter(){

                            public boolean accept(File pathname) {
                                return pathname.isFile();
                            }
                        });
    }

    /**
     * "@param bw
     *
     * @param bw
     * @param o
     */
    public static void println(BufferedWriter bw,
                               Object o) {
        try {
            bw.write(o + "\n");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getSaveFileName(
            String prompt) {
        FileDialog fd = new
                FileDialog(new Frame(),
                           prompt,
                           FileDialog.SAVE);
        fd.setVisible(true);
        fd.setVisible(false);
        String fn = fd.getDirectory() +
                    fd.getFile();
        if (fd.getFile() == null) return null; //usr canceled
        return fn;
    }

    public static String getSaveName(
            String prompt) {
        FileDialog fd = new
                FileDialog(new Frame(),
                           prompt,
                           FileDialog.SAVE);
        fd.setVisible(true);
        fd.setVisible(false);
        String fn = fd.getFile();
        if (fd.getFile() == null) return null; //usr canceled
        return fn;
    }

    public static String getSaveDirectoryName(
            String prompt) {
        FileDialog fd = new
                FileDialog(new Frame(),
                           prompt,
                           FileDialog.SAVE);
        fd.setVisible(true);
        fd.setVisible(false);
        return fd.getDirectory();
    }


    public static void saveFile(File file,
                                String newText) {
        try {
            char[] chars = newText.toCharArray();
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            out.write(chars);
            out.close();
        } catch (IOException e) {
            System.out.println("failed reading "
                    +
                    file.getName()
                    + ": " + e);
        }
    }
}
