/*
 * Cart.java
 *
 * Created on December 3, 2002
 */

package collections.hashset;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/**
 * Demonstrates adding Product objects that already exist in a
 * HashSet. The test for existence is based on the hashCode
 * and equals methods implemented in the Product class.
 *
 * @author  Thomas Rowland
 */
public class Cart {

    private static Set products = new HashSet();

    public static void main(String[] args) {
        Cart cart = new Cart();
        Product product;

        //add a product to the cart
        product = new Product(1234, "Pasta", "Ziti, 16oz box", 3, 1.45);
        cart.addProduct(product);

        //adding the same product again will fail
        product = new Product(1234, "Pasta", "Ziti, 16oz box", 1, 1.45);
        cart.addProduct(product);

        //so it must first be removed then added
        cart.removeProduct(product);
        cart.addProduct(product);

        //list the products
        Iterator iter = products.iterator();
        while (iter.hasNext()) {
            System.out.println((Product) iter.next());
        }

    }

    public void addProduct(Product product) {
        if (products.add(product))
            System.out.println("New product added.\n");
        else
            System.out.println("Product already exists!\n");
    }

    public void removeProduct(Product product) {
        if (products.remove(product))
            System.out.println("Product removed.\n");
        else
            System.out.println("Product not found!\n");
    }
}
