/**
 *
 * @author D. Lyon
 * @version 1.0
 * Date: Apr 1, 2002
 * Time: 2:39:17 PM
 */
package classUtils.putils;

import classUtils.reflection.ReflectUtil;
import futils.DirList;
import gui.dialogs.ProgressDialog;

import java.io.*;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.prefs.Preferences;

public class ClassListBean implements Serializable {
    private ClassPathBean cpb = null;
    private Vector v = new Vector();
    private static final String key = "ClassListBean";
    private ProgressDialog pd = ProgressDialog.getInstance();

    public ClassListBean(ClassPathBean cpb) {
        this.cpb = cpb;
    }

    public Vector getVector() {
        return v;
    }

    public void scan() {
        pd.setVisible(true);
        pd.setText("processing directories");
        processDirectories();
        pd.setText("processing jars and zips");
        processJarsAndZips();
        pd.setVisible(false);
    }

    private void processJarsAndZips() {
        File dirs[] = cpb.getJarsAndZips();
        for (int i = 0; i < dirs.length; i++)
            loadClassesInJarsAndZips(dirs[i]);
    }

    private void loadClassesInJarsAndZips(File dir) {
        try {
            JarFile jf = new JarFile(dir);
            jf.entries();
        } catch (IOException e) {
            pd.setText(e+"");
        }
    }


    private void processDirectories() {
        File dirs[] = cpb.getDirs();
        for (int i = 0; i < dirs.length; i++)
            loadClassesInDir(dirs[i]);
    }

    private void loadClassesInDir(File dir) {
        DirList dl = new DirList(dir,".class");
        File f[] = dl.getFilesNotDirectories();
        System.out.println("loading dir:"+dir);
        pd.setMinimum(0);
        pd.setMaximum(f.length);
        pd.setIndeterminate(false);
        pd.setSize(200,200);
        pd.setVisible(true);
        for (int i = 0; i < f.length; i++) {
            pd.setAmountDone(i);

            Class aClass=null;
            try {
               System.out.println(f[i]+" loading...");
                aClass = ClassPathUtils.getClass(f[i]);
            } catch (Exception e) {
               pd.setText(e.getMessage());
                continue;
            }
            add(aClass);
        }
        System.out.println("done with:"+dir);
    }

    public void add(Class c) {
        if (c == null) return;
        v.addElement(c);
    }

    public void add(Class c[]) {
        for (int i = 0; i < c.length; i++)
            add(c[i]);
    }

    public static void sort(Class ca[]) {
        Arrays.sort(ca,
                new ClassComparator());
    }
    /**
     * Overwrite the old class list with a new one
     * @param classes
     */
    public void setClasses(Class classes[]) {
        v = new Vector();
        for (int i=0; i < classes.length; i++)
            v.addElement(classes[i]);

    }

    private static class ClassComparator implements Comparator {
        public int compare(Object a, Object b) {
            return ((Class) a).getName().compareTo(((Class) b).getName());
        }
    }

    public static void main(String args[]) {
        Package p = Package.getPackage("java.lang");
        System.out.println(p);
    }


    public int getNumberOfMethods() {
        Class ca[] = getClasses();
        int n = 0;
        for (int i = 0; i < ca.length; i++) {
            ReflectUtil ru =
                    new ReflectUtil(ca[i]);
            n = n + ru.getMethods().length;
        }
        return n;
    }

    public Class[] getClasses() {
        Class ca[] = new Class[v.size()];
        v.copyInto(ca);
        return ca;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < v.size(); i++)
            sb.append(v.elementAt(i) + "");
        return sb.toString();
    }

    public void print() {
        for (int i = 0; i < v.size(); i++)
            System.out.println(v.elementAt(i));
        System.out.println("printed "
                + v.size() + " classes");
    }

    public int getSize() {
        return v.size();
    }

    /**
     * saves the properties to the Preferences of the userRoot
     */
    public void save() {
        try {
            Preferences p = Preferences.userRoot();
            ByteArrayOutputStream baos = new
                    ByteArrayOutputStream();
            ObjectOutputStream oos = new
                    ObjectOutputStream(baos);
            oos.writeObject(this);
            baos.close();
            p.putByteArray(key, baos.toByteArray());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * restores the properties from the preference in the user root.
     */
    public static ClassListBean restore() {
        try {
            Preferences p = Preferences.userRoot();
            byte b [] = p.getByteArray(key, null);
            if (b == null)
                return new ClassListBean(ClassPathBean.restore());
            ByteArrayInputStream bais = new
                    ByteArrayInputStream(b);
            ObjectInputStream ois = new
                    ObjectInputStream(bais);
            Object o = ois.readObject();
            bais.close();
            return (ClassListBean) o;
        } catch (IOException e) {
        } catch (ClassNotFoundException e) {
        }
        return new ClassListBean(ClassPathBean.restore());
    }

}
