package classUtils.pathUtils;

//   don't create file entries on startup; create them only when demanded

// todo: expand first node level on startup


import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import java.io.File;
import java.util.*;

class FileComparator implements Comparator {
    /**
     * 1) compare name 2) compare path
     */
    public int compare(Object obj1, Object obj2) {
        File left = (File) obj1;
        File right = (File) obj2;
        int result = left.getName().compareToIgnoreCase(right.getName());
        if (result == 0)
            result =
                    left.getAbsolutePath().compareToIgnoreCase(
                            right.getAbsolutePath());
        return result;
    }
}


public class ClassPathModel implements TreeModel {


    public static void collectLibraryPathEntries(
            ClassPathContainer parent, File unsortedFiles[]) {
        if (unsortedFiles == null)
            return;

        // ignore folders
        // only include files (aka libraries)
        //  ending with .dll or .so

        ArrayList files = new ArrayList();
        for (int i = 0; i < unsortedFiles.length; i++) {
            File file = unsortedFiles[i];

            String fileNameLower = file.getName().toLowerCase();

            if (!file.isDirectory() &&
                    (fileNameLower.endsWith(".dll")
                    || fileNameLower.endsWith(".so")
                    ))
                files.add(file);
        }

        Collections.sort(files, new FileComparator());

        for (Iterator it = files.iterator(); it.hasNext();) {
            File file = (File) it.next();

            FilePathNode node = new FilePathNode(file);
            parent.addChild(node);
        }
    }

    public static void collectClassPathEntries(ClassPathContainer parent,
                                               File unsortedFiles[]) {
        if (unsortedFiles == null)
            return;

        // separate files into folders and files (e.g. jars)

        ArrayList folders = new ArrayList();
        ArrayList files = new ArrayList();

        for (int i = 0; i < unsortedFiles.length; i++) {
            File file = unsortedFiles[i];

            if (file.isDirectory())
                folders.add(file);
            else
                files.add(file);
        }

        // fix: add FileComparator.getFileComparator() to FileComparator
        //   to avoid creating a new one for every sort

        Collections.sort(folders, new FileComparator());
        Collections.sort(files, new FileComparator());

        for (Iterator it = folders.iterator(); it.hasNext();) {
            File folder = (File) it.next();

            FolderPathNode node = new FolderPathNode(folder);
            parent.addChild(node);

            collectClassPathEntries(node, folder.listFiles());
        }

        for (Iterator it = files.iterator(); it.hasNext();) {
            File file = (File) it.next();

            FilePathNode node = new FilePathNode(file);
            parent.addChild(node);
        }
    }


    public static ClassPathNode createClassPathNode(String title,
                                                    String classPath) {
        // todo: mark top-level jars
        // todo: preserve original class path entries

        ClassPathContainer root = new ClassPathContainer(title);

        StringTokenizer st = new StringTokenizer(classPath,
                File.pathSeparator);
        while (st.hasMoreTokens()) {
            String classPathEntry = st.nextToken();
            File file = new File(classPathEntry);

            // note: if file doesn't exist isDirectory fails,
            //   therefore, we have to use our own heuristics to guess if the file is a directory/folder
            //  (if the file ends with .jar or .zip its a file; otherwise, it's a folder/directory)

            String fileNameLower = file.getName().toLowerCase();

            if (file.isDirectory()
                    || (!file.exists() &&
                    !(fileNameLower.endsWith(".jar")
                    || fileNameLower.endsWith(".zip")))) {
                FolderPathNode node = new FolderPathNode(classPathEntry,
                        file,
                        true);
                root.addChild(node);

                collectClassPathEntries(node, file.listFiles());
            } else {
                FilePathNode node = new FilePathNode(classPathEntry,
                        file,
                        true);
                root.addChild(node);
            }
        }

        return root;
    }

    public static ClassPathNode createLibraryPathNode(String title,
                                                      String libraryPath) {
        // todo: mark top-level jars
        // todo: preserve original class path entries

        ClassPathContainer root = new ClassPathContainer(title);

        StringTokenizer st = new StringTokenizer(libraryPath,
                File.pathSeparator);
        while (st.hasMoreTokens()) {
            String libraryPathEntry = st.nextToken();
            File file = new File(libraryPathEntry);

            // all entries should be directories/folders

            FolderPathNode node = new FolderPathNode(libraryPathEntry,
                    file,
                    true);
            root.addChild(node);

            collectLibraryPathEntries(node, file.listFiles());
        }

        return root;
    }

    private ClassPathContainer _root;

    public ClassPathModel() {
        init();

    }

    public void init() {
        _root = new ClassPathContainer("root");

        final ClassPathNode classPathNode = createClassPathNode("java.class.path",
                        System.getProperty("java.class.path"));
        _root.addChild(classPathNode);
        _root.addChild(createClassPathNode("java.ext.dirs",
                System.getProperty("java.ext.dirs")));
        _root.addChild(createClassPathNode("java.endorsed.dirs",
                System.getProperty("java.endorsed.dirs")));
        _root.addChild(createClassPathNode("sun.boot.class.path",
                System.getProperty("sun.boot.class.path")));

        _root.addChild(createLibraryPathNode("java.library.path",
                System.getProperty("java.library.path")));
        _root.addChild(createLibraryPathNode("sun.boot.library.path",
                System.getProperty("sun.boot.library.path")));
    }

   
// TreeModel Interface
    public Object getRoot() {

        return _root;
    }

    public Object getChild(Object parent, int index) {
        // T.debug( "getChild("+index+")" );
        ClassPathNode node = (ClassPathNode) parent;
        return node.getChild(index);
    }

    public int getChildCount(Object parent) {
        ClassPathNode node = (ClassPathNode) parent;
        // T.debug( "getChildCount()="+node.getChildCount() );
        return node.getChildCount();
    }

    public boolean isLeaf(Object parent) {
        ClassPathNode node = (ClassPathNode) parent;
        // T.debug( "isLeaf()="+node.isLeaf() );
        return node.isLeaf();
    }

    public int getIndexOfChild(Object parent, Object child) {
        // T.debug( "getIndexOfChild()" );
        ClassPathNode node = (ClassPathNode) parent;
        return node.getIndexOfChild(child);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        // only needed if you edit/change tree nodes in Jtree itself which we don't do/support
    }

    EventListenerList eventListenerList = new EventListenerList();

    public void addTreeModelListener(TreeModelListener l) {
        eventListenerList.add(TreeModelListener.class, l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        eventListenerList.remove(TreeModelListener.class, l);
    }

} 
