package classUtils.loaders;

//package net.compute;


import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.StringTokenizer;

/**
 * 1. Use the ComputeClient to create a Reloader
 * that gives you bytes codes.
 * 2. Get the RemoteClassLoader and send it to the
 *   compute server.
 * 3. The compute server define and computes the class using
 *   the remote class loader.
 * 4. It then returns the answer to the compute client.
 */

public class DynamicClassLoadingComputeClient
        implements Runnable {
    private ByteCodeContainer remoteClassLoader;
    private String computeServer = "172.16.11.107";
    private int computeServerPort = 8086;

    public void setComputableObject(ComputableObject co) {

        //remoteClassLoader = rcl;
    }

    public String[] getSystemClassPaths() {
        String s = System.getProperty("java.class.path");
        StringTokenizer st = new StringTokenizer(s, ";");
        int n = st.countTokens();
        String paths[] = new String[n];
        for (int i = 0; i < n; i++)
            paths[i] = st.nextToken();
        return paths;
    }

    public void setRemoteClassLoader() {
        String paths[] = getSystemClassPaths();

        String classPath = paths[0];
        String className1 = "distClasses.ComputeThis";

        byte[] b = null;

        try {

            Reloader rl =
                    new Reloader(classPath);
            rl.loadClass(className1);
            b = rl.getByteCodes(className1);
            //print(b);
            remoteClassLoader = new ByteCodeContainer(className1, b);
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void main(String args[]) {
        DynamicClassLoadingComputeClient cc = new DynamicClassLoadingComputeClient();
        cc.setRemoteClassLoader();
        //cc.setComputableObject( new ANewComputableObject());
        cc.run();
    }

    public void run() {
        try {
            Socket s
                    = new Socket(computeServer, computeServerPort);
            ObjectInputStream
                    ois =
                    new ObjectInputStream(
                            s.getInputStream());
            ObjectOutputStream
                    oos =
                    new ObjectOutputStream(
                            s.getOutputStream());

            if (remoteClassLoader == null) {
                System.out.println("The Object is null 1");
                return;
            }

            oos.writeObject(remoteClassLoader);
            // block the thread of execution
            // until the computation is finished by
            // the compute server. E.g.
            // a = f(b);
            Object o = ois.readObject();
            System.out.println(o);
            ois.close();
            oos.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}