package classUtils.javassist.sample.rmi;

import classUtils.javassist.rmi.ObjectImporter;
import classUtils.javassist.rmi.ObjectNotFoundException;
import classUtils.javassist.web.Viewer;

public class ComputationClient {
    private ObjectImporter objectImporter;
    private RemoteComputation computable;


    public ComputationClient() {
        Viewer viewer = (Viewer) getClass().getClassLoader();
        objectImporter = new ObjectImporter(
                viewer.getServer(),
                viewer.getPort());
        try {
            //lookupComputation();
            lookupJob();
        } catch (ObjectNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void lookupComputation() throws ObjectNotFoundException {
        Object obj = objectImporter.lookupObject("computation");
        Class c = obj.getClass();
        computable = (RemoteComputation) obj;
        System.out.println("got computation as:"
                + c.getName());
        if (computable instanceof RemoteComputation)
            System.out.println("this is computable");
        else
            System.out.println("this is not computable");

        System.out.println(computable.compute(new Job()));
        System.out.println("computation computed!");
    }

    private void lookupJob()
            throws ObjectNotFoundException {
        Object obj =
                objectImporter.lookupObject("job");
        Class c = obj.getClass();
        Job j = (Job) obj;
        System.out.println("got job as:"
                + c.getName());
        if (j instanceof Job)
            System.out.println("this is a Job");
        else
            System.out.println("this is not computable");

        System.out.println(j.compute());
        System.out.println("computation computed!");
    }


    public static void main(String[] args) {
        new ComputationClient();


    }
}
