package classUtils.dumper;


import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;


/**
 * This class defines a FieldInfo in the class
 * file. Fields are used to
 * describe instance variables in a class. The
 * toString() method is
 * augmented by a version that takes an array of
 * ConstantPoolInfo
 * objects (a constant pool). When a constant pool
 * is available the
 * toString() method generates a declaration for
 * the field as it would
 * appear in Java source.
 *
 * @version 1.3, 16 Aug 1995
 */


public class FieldInfo {

    short accessFlags;

    ConstantPoolInfo name;

    ConstantPoolInfo signature;

    AttributeInfo attributes[];


    public boolean read(DataInputStream di,
                        ConstantPoolInfo pool[])
            throws IOException {
        int count;
        accessFlags = di.readShort();
        name = pool[di.readShort()];
        signature = pool[di.readShort()];
        count = di.readShort();
        if (count != 0) {
            attributes =
            new AttributeInfo[count];
            for (int i = 0; i < count; i++) {
                attributes[i] =
                new AttributeInfo();
                if (!attributes[i].read(di,
                                        pool))
                    return (false);
            }
        }
        return (true);
    }


    public void write(DataOutputStream dos,
                      ConstantPoolInfo pool[])
            throws IOException, Exception {
        dos.writeShort(accessFlags);
        dos.writeShort(
                ConstantPoolInfo.indexOf(name,
                                         pool));
        dos.writeShort(
                ConstantPoolInfo.indexOf(
                        signature, pool));
        if (attributes == null) {
            dos.writeShort(0);
        } else {
            dos.writeShort(attributes.length);
            for (int i = 0;
                 i < attributes.length;
                 i++) {
                attributes[i].write(dos, pool);
            }
        }
    }


    public String toString() {
        StringBuffer x = new StringBuffer();
        x.append(
                ClassFile.accessString(
                        accessFlags));
        x.append(
                ClassFile.typeString(
                        signature.toString(),
                        name.toString()));
        if (attributes != null) {
            x.append(
                    " = " +
                    attributes[0].toString());
        }
        return (x.toString());
    }


    public String toString(
            ConstantPoolInfo pool[]) {
        StringBuffer x = new StringBuffer();
        String mytype;
        x.append(
                ClassFile.accessString(
                        accessFlags));
        mytype =
        ClassFile.typeString(
                signature.toString(),
                name.toString());
        x.append(mytype);
        if (attributes != null) {
            if (mytype.startsWith("boolean")) {
                x.append(
                        " " +
                        attributes[0].toBoolean(
                                pool));
            } else
                x.append(
                        " " +
                        attributes[0].toString(
                                pool));
        }
        return (x.toString());
    }

}

