package bookExamples.ch44Printing.cdUtil;


import futils.Futil;
import gui.ClosableJFrame;
import gui.run.RunMenuBar;
import gui.layouts.VerticalFlowLayout;

import javax.swing.*;
import java.awt.*;
import java.io.File;
import java.util.Calendar;
import java.util.GregorianCalendar;


/**
 * Created by IntelliJ IDEA. User: Paul Date: Apr 9, 2005 Time: 5:31:33 PM
 * To change this template use File | Settings | File Templates.
 */

public class CdLabelPrinter extends ClosableJFrame {
    public JPanel p = new JPanel(new VerticalFlowLayout());
    public JLabel jl = new JLabel();
    public Container c = getContentPane();
    public JPanel borderPanel = new JPanel();

    CdLabelPrinter() {

        borderPanel.setLayout(new BorderLayout());
        borderPanel.setBorder(BorderFactory.createEtchedBorder());
        borderPanel.setBackground(Color.white);
        c.setBackground(Color.white);
        c.setLayout(new BorderLayout());

        borderPanel.add(getRunMenuBar(), BorderLayout.NORTH);


        p.setBackground(Color.white);

        borderPanel.add(p, BorderLayout.CENTER);
        p.add(jl);
        c.add(borderPanel);
        this.setTitle(getDateLabel());
        setDateLabel();
    }

    public RunMenuBar getRunMenuBar() {
        RunMenuBar rmb = new RunMenuBar();
        rmb.add(FileMenu.getFileMenu(this));
        rmb.add(dateMenu.getDateMenu(this));
        return rmb;
    }

    public void populatePanel(JPanel p) {
       //FileList fl = new FileList();
        File f = Futil.getReadDirFileJTree("select a start file");
        //f is a directory; we need to list its contents
        File list[] = f.listFiles();

        JLabel l = new JLabel();
        jl.setText(getDateLabel());
        for (int i = 0; i < list.length; ++i) {
            //I like listings with 1-based indexes.  So sue me.
            if (list[i].isDirectory()) {
                l = new JLabel('\\' + list[i].getName());
            } else {
                l = new JLabel(list[i].getName());
            }
            p.add(l);
        }


    }

    public void setDateLabel(){
        jl.setText(getDateLabel());
    }

    public static String getDateLabel() {
        GregorianCalendar gc = new GregorianCalendar();
        String date = Integer.toString(gc.get(Calendar.YEAR));
        if (gc.get(Calendar.MONTH) < 10) date = date + "0";
        date += Integer.toString(gc.get(Calendar.MONTH) + 1);
        if (gc.get(Calendar.DAY_OF_MONTH) < 10) date = date + "0";
        date += Integer.toString(gc.get(Calendar.DAY_OF_MONTH));
         return date;
    }

    public static void main(String[] args) {
        CdLabelPrinter labelPrinter = new CdLabelPrinter();
        labelPrinter.setSize(357, 369);
        labelPrinter.setVisible(true);
        try {
            Thread.sleep(200);
        } catch (InterruptedException e) {

        }

    }

    public void paintThis() {
        paint(getGraphics());
    }

    private static String[] getMonths() {
        String months[] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        return months;
    }

    public static String getMonth() {
        String[] months = getMonths();
        return (String) (gui.In.multiPrompt(months,
                "select a Month",
                "MonthDialog"));
    }

    public static int getMonthID(String month) {
        String months[] = getMonths();
        for (int i = 0; i < months.length; i ++) {
            if (months[i].equals(month))
                return i + 1;
        }
        return -1;
    }

    public static String getDay(String month) {
        String[] days = getDays(month);
        return (String) (gui.In.multiPrompt(days,
                "select a Day",
                "DayDialog"));
    }

    private static String[] getDays(String month) {

        if (month.equals("Jan") || month.equals("Mar") || month.equals("May") || month.equals("Jul") || month.equals("Aug") || month.equals("Oct") || month.equals("Dec")) {
            return new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
        }
        if (month.equals("Apr") || month.equals("Jun") || month.equals("Sep") || month.equals("Nov")) {
            return new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30"};
        }
        if (month.equals("Feb")) {
            return new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28"};
        }

        return new String[]{"Null"};
    }

    public static String getYear() {
        String[] years = getYears();
        return (String) (gui.In.multiPrompt(years,
                "select a Year",
                "YearDialog"));
    }

    private static String[] getYears() {
        String years[] = {"1981", "1982", "1983", "1984", "1985", "1986", "1987", "1988", "1989", "1990", "1991", "1992", "1993", "1994", "1995", "1996", "1997", "1998", "1999", "2000", "2001", "2002", "2003", "2004", "2005"};
        return years;
    }

}
