package bookExamples.ch44Printing.cdLabel;
import javax.swing.*;
import java.awt.*;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;

public class MyHex {
    public static Icon getOpenIcon() {
        return new ImageIcon(getImage(open, 16, 16), "open");
    }
    public static Icon getClockIcon() {
           return new ImageIcon(getImage(clock, 16, 16), "clock");
       }
     public static Icon getPrinterIcon() {
           return new ImageIcon(getImage(printer, 19, 19), "printer");
       }
    public static Icon getSaveIcon() {
        return new ImageIcon(getImage(save, 16, 16), "save");
    }

    public static Icon getCaptureIcon() {
        return new ImageIcon(getImage(capture, 16, 16), "capture");
    }

    public static Icon getRevertIcon() {
        return new ImageIcon(getImage(revert, 16, 16), "revert");
    }

    public static Image getImage(int pels[], int width, int height) {
        Toolkit tk =
                Toolkit.getDefaultToolkit();
        ColorModel cm = tk.getColorModel();

        return tk.createImage(new
                MemoryImageSource(width,
                        height,
                        cm,
                        pels, 0,
                        width));
    }
    private static int clock[] = {
    0xfffefefe, 0xfff6f6f6, 0xffffffff, 0xfff5f5f5, 0xffffffff, 0xffffffff, 0xffffffff, 0xfffcfcfc, 0xffffffff, 0xfffafafa, 0xfffefefe, 0xffffffff, 0xfffbfbfb, 0xffffffff, 0xfffafafa, 0xffffffff,
    0xffffffff, 0xfff7f7f7, 0xfffcfcfc, 0xffffffff, 0xfffbfbfb, 0xffffffff, 0xffe4e4e4, 0xffffffff, 0xffffffff, 0xffffffff, 0xfff7f7f7, 0xfff5f5f5, 0xfffdfdfd, 0xffffffff, 0xfffafafa, 0xffffffff,
    0xffffffff, 0xffededed, 0xffffffff, 0xfffdfdfd, 0xffffffff, 0xffdadada, 0xff7e7e7e, 0xff545454, 0xff656565, 0xff4e4e4e, 0xffc6c6c6, 0xffffffff, 0xfff8f8f8, 0xffffffff, 0xfffbfbfb, 0xfff6f6f6,
    0xfffdfdfd, 0xffffffff, 0xffffffff, 0xffffffff, 0xff7c7c7c, 0xff383838, 0xffffffff, 0xffdddddd, 0xffa8a8a8, 0xffffffff, 0xff5d5d5d, 0xff5d5d5d, 0xffeeeeee, 0xfffcfcfc, 0xffffffff, 0xffffffff,
    0xffffffff, 0xfffafafa, 0xfff5f5f5, 0xff666666, 0xffc9c9c9, 0xffbfbfbf, 0xffffffff, 0xff797979, 0xff484848, 0xffffffff, 0xffaaaaaa, 0xffe6e6e6, 0xff464646, 0xffffffff, 0xfffdfdfd, 0xfff8f8f8,
    0xfff4f4f4, 0xffffffff, 0xfff4f4f4, 0xff272727, 0xffcacaca, 0xffffffff, 0xfffbfbfb, 0xffdcdcdc, 0xff7f7f7f, 0xff3e3e3e, 0xffffffff, 0xffe5e5e5, 0xff737373, 0xffa7a7a7, 0xfff0f0f0, 0xffffffff,
    0xffffffff, 0xffffffff, 0xff646464, 0xfff5f5f5, 0xffd7d7d7, 0xfff7f7f7, 0xffffffff, 0xffcbcbcb, 0xff2a2a2a, 0xff323232, 0xffe8e8e8, 0xffffffff, 0xffffffff, 0xff585858, 0xfff5f5f5, 0xfff7f7f7,
    0xffffffff, 0xfff4f4f4, 0xff777777, 0xffdadada, 0xffffffff, 0xffffffff, 0xfff6f6f6, 0xffd1d1d1, 0xff000000, 0xffffffff, 0xffffffff, 0xffffffff, 0xffe8e8e8, 0xff5f5f5f, 0xffffffff, 0xffffffff,
    0xffffffff, 0xffefefef, 0xff646464, 0xffb0b0b0, 0xfff3f3f3, 0xffffffff, 0xffffffff, 0xff888888, 0xff7a7a7a, 0xffffffff, 0xfffbfbfb, 0xffffffff, 0xffbdbdbd, 0xff606060, 0xffffffff, 0xfffefefe,
    0xfffdfdfd, 0xffffffff, 0xff6e6e6e, 0xffffffff, 0xfff9f9f9, 0xffefefef, 0xfff4f4f4, 0xfffdfdfd, 0xfff9f9f9, 0xfff5f5f5, 0xfff2f2f2, 0xffffffff, 0xfffdfdfd, 0xff5b5b5b, 0xffffffff, 0xfff7f7f7,
    0xfff2f2f2, 0xffffffff, 0xffa4a4a4, 0xff666666, 0xffb4b4b4, 0xffffffff, 0xffffffff, 0xfffefefe, 0xfffafafa, 0xffffffff, 0xffffffff, 0xffdcdcdc, 0xff6e6e6e, 0xff6d6d6d, 0xffffffff, 0xffffffff,
    0xffffffff, 0xfff6f6f6, 0xffffffff, 0xff464646, 0xfffbfbfb, 0xffe3e3e3, 0xffffffff, 0xfff6f6f6, 0xfffcfcfc, 0xffefefef, 0xffe1e1e1, 0xffffffff, 0xff545454, 0xffffffff, 0xffefefef, 0xfffefefe,
    0xffffffff, 0xfff9f9f9, 0xffffffff, 0xffffffff, 0xff393939, 0xff676767, 0xffffffff, 0xfff5f5f5, 0xffb9b9b9, 0xffffffff, 0xff747474, 0xff414141, 0xffececec, 0xffe5e5e5, 0xffffffff, 0xffffffff,
    0xfff8f8f8, 0xffffffff, 0xffe9e9e9, 0xffffffff, 0xffffffff, 0xff919191, 0xff424242, 0xff646464, 0xff6b6b6b, 0xff303030, 0xff8d8d8d, 0xffffffff, 0xfff7f7f7, 0xfff7f7f7, 0xffffffff, 0xffefefef,
    0xffffffff, 0xfff1f1f1, 0xffffffff, 0xffe9e9e9, 0xffededed, 0xffffffff, 0xffffffff, 0xffe4e4e4, 0xfffcfcfc, 0xffffffff, 0xffffffff, 0xfffafafa, 0xfff3f3f3, 0xffffffff, 0xfff3f3f3, 0xffffffff,
    0xfffefefe, 0xfffefefe, 0xfffbfbfb, 0xffffffff, 0xffffffff, 0xfff9f9f9, 0xfffafafa, 0xffffffff, 0xffffffff, 0xfff9f9f9, 0xffffffff, 0xfffefefe, 0xffffffff, 0xffffffff, 0xffffffff, 0xfff7f7f7,
    };

    private static int save[] = {
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xd6d6ce, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xffbdbd00, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xffbdbd00, 0xffbdbd00, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xffbdbd00, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xffbdbd00, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xffbdbd00, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xff000000, 0xffbdbd00, 0xffbdbd00, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xffbdbd00, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce,
    };
    private static int revert[] = {
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xff000000,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xff000000,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xff000000,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000,
        0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,

    };
    private static int capture[] = {
        16, 16, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff848484, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff848484, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff848484, 0xff848484, 0xffffffff, 0xffffffff, 0xffffffff, 0xff000000, 0xff848484, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff848484, 0xff848484, 0xffffffff, 0xffffffff, 0xffffffff, 0xff000000, 0xff848484, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff848484, 0xff848484, 0xffffffff, 0xffffffff, 0xffffffff, 0xff000000, 0xff848484, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce,
        0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff848484, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff848484, 0xd6d6ce, 0xff008400, 0xff848484, 0xd6d6ce,
        0xff848484, 0xff008400, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff848484,
        0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xff000000, 0xff848484, 0xff000000, 0xff848484, 0xff000000, 0xff848484, 0xff000000, 0xff848484, 0xff000000, 0xff848484, 0xff000000, 0xff848484, 0xff000000, 0xff848484, 0xff000000, 0xff000000,
        0xff848484, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff008400, 0xff848484, 0xff008400, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff848484, 0xff000000,
        0xff848484, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xffffffff, 0xff848484, 0xff008400, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xff848484, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xffffffff, 0xffffffff, 0xd6d6ce, 0xd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff848484, 0xff000000,
        0xff848484, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xffffffff, 0xd6d6ce, 0xffffffff, 0xff848484, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xff848484, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xffffffff, 0xd6d6ce, 0xd6d6ce, 0xff848484, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff848484, 0xff000000,
        0xff848484, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xd6d6ce, 0xff848484, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xff848484, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
    };

    public static Icon getExitIcon() {
        return new ImageIcon(getImage(exit, 16, 16), "exit");
    }

    private static int exit[] = {
        0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7,
        0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xff424242,
        0xffffffff, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff848484, 0xff424242,
        0xffffffff, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff848484, 0xff424242,
        0xffffffff, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xff848484, 0xff424242,
        0xffffffff, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff848484, 0xff424242,
        0xffffffff, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff848484, 0xff424242,
        0xffffffff, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff848484, 0xff424242,
        0xffffffff, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff848484, 0xff424242,
        0xffffffff, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff848484, 0xff424242,
        0xffffffff, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xff848484, 0xff424242,
        0xffffffff, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff848484, 0xff424242,
        0xffffffff, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff848484, 0xff424242,
        0xffffffff, 0xff848484, 0xff848484, 0xff848484, 0xff848484, 0xff848484, 0xff848484, 0xff848484, 0xff848484, 0xff848484, 0xff848484, 0xff848484, 0xff848484, 0xff848484, 0xff848484, 0xff424242,
        0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242, 0xff424242,
        0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7, 0xa5cef7,
    };


    private static int open [] = {
        0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce,
        0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce,
        0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xffd6d6ce, 0xff000000, 0xffd6d6ce,
        0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xffd6d6ce,
        0xffd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xff000000, 0xff000000, 0xff000000, 0xffd6d6ce,
        0xff000000, 0xffffffff, 0xffffff00, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce,
        0xff000000, 0xffffff00, 0xffffffff, 0xffffff00, 0xffffffff, 0xffffff00, 0xffffffff, 0xffffff00, 0xffffffff, 0xffffff00, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce,
        0xff000000, 0xffffffff, 0xffffff00, 0xffffffff, 0xffffff00, 0xffffffff, 0xffffff00, 0xffffffff, 0xffffff00, 0xffffffff, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce,
        0xff000000, 0xffffff00, 0xffffffff, 0xffffff00, 0xffffffff, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000,
        0xff000000, 0xffffffff, 0xffffff00, 0xffffffff, 0xff000000, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xff000000, 0xffd6d6ce,
        0xff000000, 0xffffff00, 0xffffffff, 0xff000000, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xff000000, 0xffd6d6ce, 0xffd6d6ce,
        0xff000000, 0xffffffff, 0xff000000, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce,
        0xff000000, 0xff000000, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xffbdbd00, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce,
        0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce,
        0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce,
        0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce, 0xffd6d6ce};


   private static int printer[] = {
   0xffcfceca, 0xffd4d3cf, 0xffdcdbd7, 0xffd5d4d0, 0xffd1d0cc, 0xffcfceca, 0xffe5e4e0, 0xffc4c3bf, 0xffdad9d5, 0xffdeddd9, 0xff383733, 0xff6c6b67, 0xff8c8b87, 0xffc0bfbb, 0xffe7e6e2, 0xffe9e8e3, 0xffe3e2dd, 0xffdadad2, 0xffcacac2,
   0xffdddcd8, 0xffd7d6d2, 0xffc1c0bc, 0xffc6c5c1, 0xffeeede9, 0xffcbcac6, 0xffd8d7d3, 0xffdfdeda, 0xfff3f2ee, 0xff52514d, 0xff090804, 0xff31302c, 0xff252420, 0xff010000, 0xff0d0c08, 0xff1a1915, 0xff3a3934, 0xffdadad2, 0xffd8d8d0,
   0xffc7c6c2, 0xffe1e0dc, 0xffdeddd9, 0xffe3e2de, 0xffdbdad6, 0xffc2c1bd, 0xffb7b6b2, 0xffbebdb9, 0xff32312d, 0xff010000, 0xffa5a4a0, 0xffa1a09c, 0xff84837f, 0xffa2a19d, 0xff82817d, 0xff363531, 0xff060500, 0xffe0dfda, 0xffc9c8c3,
   0xffd1d0cc, 0xffd7d6d2, 0xffdeddd9, 0xffb5b4b0, 0xff272622, 0xff0f0e0a, 0xff010000, 0xff171612, 0xff44433f, 0xffacaba7, 0xffe6e5e1, 0xffdcdbd7, 0xffd7d6d2, 0xffe0dfdb, 0xffe0dfdb, 0xff5d5c58, 0xff6f6e6a, 0xfffaf9f4, 0xffd5d4d0,
   0xffd8d7d3, 0xffdcdbd7, 0xff9e9d99, 0xff080703, 0xff191814, 0xffb3b2ae, 0xff979692, 0xff3e3d39, 0xff575652, 0xff666561, 0xffe0dfdb, 0xffefeeea, 0xffc0bfbb, 0xffe7e6e2, 0xffe3e2de, 0xff363531, 0xff010000, 0xff64635f, 0xffc2c1bf,
   0xffd8d7d3, 0xffd4d3cf, 0xff81807c, 0xff030200, 0xffa8a7a3, 0xffe4e3df, 0xffe2e1dd, 0xffe8e7e3, 0xffb4b3af, 0xffa7a6a2, 0xff706f6b, 0xff4e4d49, 0xff91908c, 0xffa8a7a3, 0xffb8b7b3, 0xff52514d, 0xff0b0a08, 0xff010000, 0xff656462,
   0xffcac9c5, 0xffe6e5e1, 0xff565551, 0xff100f0b, 0xffe8e7e3, 0xffdad9d5, 0xffd0cfcb, 0xffcdccc8, 0xffdad9d5, 0xffcbcac6, 0xffe0dfdb, 0xffd6d5d1, 0xffb6b5b1, 0xff8d8c88, 0xff777672, 0xff8e8d89, 0xff8d8c8a, 0xff030102, 0xff545253,
   0xffd4d3cf, 0xfff1f0ec, 0xff21201c, 0xff292824, 0xffe3e2de, 0xffdcdbd7, 0xffe7e6e2, 0xffd0cfcb, 0xffd4d3cf, 0xffbcbbb7, 0xff868581, 0xffeae9e5, 0xffcfceca, 0xffe6e5e1, 0xffdfdeda, 0xffafaeaa, 0xffb4b2b3, 0xff110f10, 0xff3d3b3c,
   0xffd0cfcb, 0xfff5f4f0, 0xff010000, 0xff2e2d29, 0xffb9b8b4, 0xff4e4d49, 0xffb1b0ac, 0xffe8e7e3, 0xffe3e2de, 0xffd9d8d4, 0xffe2e1dd, 0xffd5d4d0, 0xffc6c5c1, 0xffe0dfdb, 0xffdeddd9, 0xff666561, 0xfffbf9fa, 0xff181617, 0xff393738,
   0xffd8d7d3, 0xffebeae6, 0xff010000, 0xff1e1d19, 0xfffffefa, 0xff81807c, 0xff6f6e6a, 0xff3d3c38, 0xff3a3935, 0xff959490, 0xffd6d5d1, 0xffe7e6e2, 0xffdddcd8, 0xffc0bfbb, 0xffcdccc8, 0xff807f7b, 0xffebeae8, 0xff151314, 0xff282627,
   0xffd4d3cf, 0xffdbdad6, 0xff6c6b67, 0xff010000, 0xff969591, 0xffc5c4c0, 0xff94938f, 0xffdbdad6, 0xffe7e6e2, 0xffacaba7, 0xff555450, 0xff44433f, 0xff81807c, 0xffefeeea, 0xff8e8d89, 0xffc2c1bd, 0xfff7f6f4, 0xff181715, 0xff1f1e1c,
   0xffcccbc7, 0xffe7e6e2, 0xffc4c3bf, 0xff010000, 0xff12110d, 0xff908f8b, 0xff7b7a76, 0xff7f7e7a, 0xff71706c, 0xff9b9a96, 0xffdeddd9, 0xfff3f2ee, 0xff878682, 0xff020100, 0xff272622, 0xffdeddd9, 0xffdddcd8, 0xff0b0a06, 0xff51504e,
   0xffd5d4d0, 0xffdcdbd7, 0xff040300, 0xff12110d, 0xffd0cfcb, 0xff5d5c58, 0xff666561, 0xff74736f, 0xff757470, 0xffb5b4b0, 0xffdad9d5, 0xfff4f3ef, 0xff474642, 0xff585753, 0xff91908c, 0xffbdbcb8, 0xff6e6d69, 0xff010000, 0xffb0afab,
   0xffc8c7c3, 0xff010000, 0xff070602, 0xff8c8b87, 0xff43423e, 0xff605f5b, 0xff8f8e8a, 0xff706f6b, 0xff888783, 0xff858480, 0xffb4b3af, 0xff6f6e6a, 0xff52514d, 0xff64635f, 0xffa09f9b, 0xffe1e0dc, 0xff080702, 0xff1a1914, 0xffecebe6,
   0xff373632, 0xff030200, 0xff4b4a46, 0xfffffffb, 0xffcbcac6, 0xff969591, 0xff6c6b67, 0xff868581, 0xff666561, 0xffc8c7c3, 0xffbcbbb7, 0xff555450, 0xff22211d, 0xff020100, 0xff070602, 0xff030200, 0xff010000, 0xff85857d, 0xffe9e9e1,
   0xffe3e2de, 0xff010000, 0xff14130f, 0xff010000, 0xff53524e, 0xffb0afab, 0xffb7b6b2, 0xffc2c1bd, 0xff9d9c98, 0xff797874, 0xffc3c2be, 0xff21201c, 0xff010000, 0xff1e1d19, 0xff363531, 0xff161511, 0xff010000, 0xffe3e3db, 0xffd5d5cd,
   0xffd4d3cf, 0xffe8e7e3, 0xff010000, 0xff100f0b, 0xff010000, 0xff040300, 0xff44433f, 0xff4c4b47, 0xffc2c1bd, 0xfff0efeb, 0xff11100c, 0xff010000, 0xff12110d, 0xfff1f0ec, 0xffdeddd9, 0xffebeae6, 0xffe2dfda, 0xffdfdcd7, 0xffdad7d2,
   0xffd6d5d1, 0xffcbcac6, 0xffedece8, 0xff010000, 0xff0a0905, 0xff0e0d09, 0xff010000, 0xff050400, 0xff020100, 0xff020100, 0xff040300, 0xff1d1c18, 0xffc8c7c3, 0xffcdccc8, 0xffe6e5e1, 0xffcecdc9, 0xffdddad5, 0xffdbd8d3, 0xffd8d5d0,
   0xffd6d5d1, 0xffdbdad6, 0xffe0dfdb, 0xffe6e5e1, 0xffecebe7, 0xffcdccc8, 0xff9e9d99, 0xff8b8a86, 0xff666561, 0xff484743, 0xff201f1b, 0xffcecdc9, 0xffe1e0dc, 0xffe4e3df, 0xffb7b6b2, 0xffd9d8d4, 0xffd6d3ce, 0xffd6d3ce, 0xffd5d2cd,
   };


}

